/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.deploy;

import com.tobedevoured.naether.util.RepoBuilder;
import java.io.File;
import java.net.MalformedURLException;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.SubArtifact;

public class DeployArtifact {
    private RemoteRepository remoteRepo;
    private String pomPath;
    private String filePath;
    private String notation;
    private Artifact jarArtifact;
    private Artifact pomArtifact;
    private Authentication authentication;

    public DeployArtifact() {
    }

    public DeployArtifact(String notation, String filePath, RemoteRepository remoteRepo) {
        this.notation = notation;
        this.jarArtifact = new DefaultArtifact(notation);
        this.filePath = filePath;
        this.jarArtifact = this.jarArtifact.setFile(new File(filePath));
        this.remoteRepo = remoteRepo;
    }

    public void setAuth(String username, String password) {
        this.authentication = new Authentication(username, password);
        if (this.getRemoteRepo() != null) {
            this.getRemoteRepo().setAuthentication(this.authentication);
        }
    }

    public void setAuth(String username, String password, String publicKeyFile, String passphrase) {
        this.authentication = new Authentication(username, password, publicKeyFile, passphrase);
        if (this.getRemoteRepo() != null) {
            this.getRemoteRepo().setAuthentication(this.authentication);
        }
    }

    public void setRemoteRepo(String url) throws MalformedURLException {
        this.setRemoteRepo(RepoBuilder.remoteRepositoryFromUrl(url));
    }

    public void setRemoteRepo(RemoteRepository remoteRepo) {
        this.remoteRepo = remoteRepo;
        if (this.authentication != null) {
            this.getRemoteRepo().setAuthentication(this.authentication);
        }
    }

    public RemoteRepository getRemoteRepo() {
        return this.remoteRepo;
    }

    public void setPomPath(String pomPath) {
        this.pomPath = pomPath;
        if (this.getJarArtifact() != null) {
            this.pomArtifact = new SubArtifact(this.getJarArtifact(), "", "pom");
            this.pomArtifact = this.pomArtifact.setFile(new File(this.pomPath));
        }
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getPomPath() {
        return this.pomPath;
    }

    public Artifact getPomArtifact() {
        return this.pomArtifact;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
        if (this.getJarArtifact() != null) {
            this.jarArtifact = this.getJarArtifact().setFile(new File(filePath));
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setNotation(String notation) {
        this.notation = notation;
        this.jarArtifact = new DefaultArtifact(notation);
        if (this.getFilePath() != null) {
            this.jarArtifact = this.jarArtifact.setFile(new File(this.getFilePath()));
        }
        if (this.getPomPath() != null) {
            this.pomArtifact = new SubArtifact(this.getJarArtifact(), "", "pom");
            this.pomArtifact = this.pomArtifact.setFile(new File(this.getPomPath()));
        }
    }

    public String getNotation() {
        return this.notation;
    }

    public Artifact getJarArtifact() {
        return this.jarArtifact;
    }
}

