/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.repo;

import com.tobedevoured.naether.util.Notation;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

@Component(role=WorkspaceReader.class, hint="local-build")
public class BuildWorkspaceReader
implements WorkspaceReader {
    private Map<String, Artifact> artifacts = new HashMap<String, Artifact>();
    private WorkspaceRepository workspaceRepository = new WorkspaceRepository("local-build", this.getClass());

    @Override
    public WorkspaceRepository getRepository() {
        return this.workspaceRepository;
    }

    public void addArtifact(Artifact artifact) {
        this.artifacts.put(Notation.generate(artifact), artifact);
    }

    @Override
    public File findArtifact(Artifact artifact) {
        Artifact buildArtifact = this.artifacts.get(Notation.generate(artifact));
        if (buildArtifact != null) {
            return buildArtifact.getFile();
        }
        return null;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return Collections.emptyList();
    }
}

