/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.shebang;

import com.tobedevoured.naether.impl.NaetherImpl;
import eu.javaexperience.shebang.OpenURLClassLoader;
import eu.javaexperience.shebang.ShebangTools;
import eu.javaexperience.shebang.__MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mdkt.compiler.CustomInMemoryJavaCompiler;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;

public class JavaShebang {
    protected static final OpenURLClassLoader CLASS_LOADER = new OpenURLClassLoader(ClassLoader.getSystemClassLoader());
    protected static boolean MISSING_RT_JAR = false;
    public static final Pattern NEW_LINE = Pattern.compile("(\r\n|\r|\n)");

    public static List<String> collectClassFilesystems() {
        URL[] urls;
        final ArrayList<String> ret = new ArrayList<String>();
        Consumer<String> add = new Consumer<String>(){

            @Override
            public void accept(String f) {
                if (new File(f).exists()) {
                    ret.add(f.toString());
                }
            }
        };
        for (URL url : urls = CLASS_LOADER.getURLs()) {
            add.accept(url.getFile());
        }
        String value = System.getProperty("sun.boot.class.path");
        if (null != value) {
            for (String f : value.split(":")) {
                add.accept(f);
            }
        } else {
            MISSING_RT_JAR = true;
        }
        return ret;
    }

    public static __MultiMap<String, String> collectAvailableClasses() throws IOException {
        final __MultiMap<String, String> ret = new __MultiMap<String, String>();
        List<String> fss = JavaShebang.collectClassFilesystems();
        Consumer<String> acceptClass = new Consumer<String>(){

            @Override
            public void accept(String name) {
                if (null != (name = ShebangTools.getSubstringBeforeFirstString(name, ".class", name))) {
                    if ((name = name.replace('/', '.')).startsWith(".")) {
                        name = ShebangTools.getSubstringAfterFirstString(name, ".", name);
                    }
                } else {
                    return;
                }
                String shortName = null;
                if (name.contains("$")) {
                    shortName = ShebangTools.getSubstringAfterLastString(name, "$", name);
                    if (null != ShebangTools.tryParseInt(shortName)) {
                        return;
                    }
                } else {
                    shortName = ShebangTools.getSubstringAfterLastString(name, ".", name);
                }
                ret.put(shortName, name);
            }
        };
        if (MISSING_RT_JAR) {
            try (InputStream is = ClassLoader.getSystemResourceAsStream("eu/javaexperience/shebang/shebang-fallback-base-classes.lst");){
                for (String cls : new String(ShebangTools.loadAllFromInputStream(is)).split("\n")) {
                    acceptClass.accept(cls);
                }
            }
        }
        for (String fs : fss) {
            File f = new File(fs);
            if (f.isDirectory()) {
                ShebangTools.find(f, a -> {
                    if (a.isFile()) {
                        String name = a.toString();
                        if ((name = ShebangTools.getSubstringAfterFirstString(name, fs, name)).endsWith(".class")) {
                            acceptClass.accept(name);
                        }
                    }
                });
                continue;
            }
            if (!f.toString().endsWith(".jar")) continue;
            ZipFile zip = new ZipFile(f);
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> ents = zip.entries();
                while (ents.hasMoreElements()) {
                    ZipEntry e = ents.nextElement();
                    String name = e.getName();
                    if (!name.endsWith(".class")) continue;
                    acceptClass.accept(name);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zip == null) continue;
                if (throwable != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                zip.close();
            }
        }
        return ret;
    }

    protected static String loadInstructionComments(String source) {
        return ShebangTools.getFirstBetween(source, "/*", "*/", null);
    }

    protected static String getLocalDependencyFile(Dependency dep) {
        Artifact art = dep.getArtifact();
        return System.getProperty("user.home") + "/.m2/repository/" + art.getGroupId().replace('.', '/') + "/" + art.getArtifactId() + "/" + art.getVersion() + "/" + art.getArtifactId() + "-" + art.getVersion() + ".jar";
    }

    public static void addJarToClassPath(String path) throws MalformedURLException {
        CLASS_LOADER.addURL(new File(path).toURI().toURL());
        System.setProperty("java.class.path", System.getProperty("java.class.path") + ":" + path);
    }

    protected static void addMavenDependencies(Set<String> deps) throws Exception {
        NaetherImpl naether = new NaetherImpl();
        for (String dep : deps) {
            if (ShebangTools.occurrenceIn(dep, ":") > 2) {
                String[] parts = dep.split(":");
                int l = parts.length;
                dep = parts[l - 3] + ":" + parts[l - 2] + ":" + parts[l - 1];
                naether.addRemoteRepositoryByUrl(ShebangTools.join(":", Arrays.copyOf(parts, l - 3)));
            }
            try {
                naether.addDependency(dep);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            naether.resolveDependencies();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collection ds = naether.currentDependencies();
        for (Dependency d : ds) {
            JavaShebang.addJarToClassPath(JavaShebang.getLocalDependencyFile(d));
        }
    }

    protected static void processInstructions(String instr) throws Exception {
        if (null == instr) {
            return;
        }
        HashSet<String> deps = new HashSet<String>();
        for (String line : NEW_LINE.split(instr)) {
            line = line.trim();
            line = line.replaceAll("^\\*", "");
            if (!(line = line.trim()).startsWith("@maven-dependency")) continue;
            String dep = ShebangTools.getSubstringAfterFirstString(line, "@maven-dependency", line);
            if ((dep = dep.trim()).startsWith(":")) {
                dep = dep.substring(1);
                dep = dep.trim();
            }
            deps.add(dep);
        }
        JavaShebang.addMavenDependencies(deps);
    }

    public static void main(String[] args) throws Throwable {
        if (args.length < 1) {
            System.err.println("Specify a script file");
            System.exit(1);
        }
        String content = ShebangTools.getFileContents(args[0]);
        String instComments = JavaShebang.loadInstructionComments(content);
        JavaShebang.processInstructions(instComments);
        String src = ShebangTools.getSubstringAfterFirstString(content, "\n", content);
        if (null == src) {
            System.err.println("Can't read the source to compile.");
            System.exit(2);
        }
        JavaShebang.compileAndRun(src, Arrays.copyOfRange(args, 1, args.length));
    }

    public static Set<String> getReferencedClasses(String src) {
        HashSet<String> ret = new HashSet<String>();
        Pattern p = Pattern.compile("[a-zA-Z_$][a-zA-Z_$0-9]*", 8);
        Matcher m = p.matcher(src);
        while (m.find()) {
            ret.add(m.group());
        }
        return ret;
    }

    protected static boolean isClassAvailable(String name) {
        try {
            Class<?> c = Class.forName(name, false, CLASS_LOADER);
            return Modifier.isPublic(c.getModifiers());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<String> getAccessibleClasses(List<String> clss) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String c : clss) {
            if (!JavaShebang.isClassAvailable(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    protected static String selectPreferredPackageClass(String cls, List<String> classes, String ... preference) {
        for (String p : preference) {
            for (String c : classes) {
                if (!c.startsWith(p)) continue;
                return c;
            }
        }
        return null;
    }

    protected static void appendImport(StringBuilder sb, String cls) {
        sb.append("import ");
        sb.append(cls.replace('$', '.'));
        sb.append(";");
    }

    public static void checkAndAddAutoImport(StringBuilder sb, __MultiMap<String, String> knownClasses, Set<String> reqClasses, Set<String> nonResolv) {
        for (String req : reqClasses) {
            List<String> k;
            if (nonResolv.contains(req) || null == (k = knownClasses.getList(req))) continue;
            if ((k = JavaShebang.getAccessibleClasses(k)).size() == 0) {
                System.err.println("No variant of `" + req + "` found");
                continue;
            }
            if (k.size() == 1) {
                if (!JavaShebang.isClassAvailable(k.get(0))) {
                    System.err.println("The only found variant of `" + req + "` is `" + k.get(0) + "` which is not accessible");
                }
                JavaShebang.appendImport(sb, k.get(0));
                continue;
            }
            String pref = JavaShebang.selectPreferredPackageClass(req, k, "java.lang.", "java.util.", "java.", "javax.");
            if (null != pref) {
                JavaShebang.appendImport(sb, pref);
                continue;
            }
            System.err.println("Multiple public variant of `" + req + "` is availabe `" + k + "`. Specify with import which one you like to use.");
        }
    }

    public static Class compileClass(String className, String content) throws Exception {
        CustomInMemoryJavaCompiler compiler = new CustomInMemoryJavaCompiler().useParentClassLoader(CLASS_LOADER).ignoreWarnings();
        Thread.currentThread().setContextClassLoader(compiler.getClassloader());
        return compiler.compile(className, content);
    }

    public static void compileAndRun(String src, String[] args) throws Exception {
        Pattern p = Pattern.compile("class\\s+(?<cls>[^\\s]+)\\s+", 8);
        Matcher m = p.matcher(src);
        if (!m.find()) {
            System.err.println("No class name found");
            System.exit(3);
        }
        Set<String> reqClasses = JavaShebang.getReferencedClasses(src);
        StringBuilder sb = new StringBuilder();
        HashSet<String> selectedClasses = new HashSet<String>();
        __MultiMap<String, String> knownClasses = JavaShebang.collectAvailableClasses();
        JavaShebang.checkAndAddAutoImport(sb, knownClasses, reqClasses, selectedClasses);
        sb.append("\n");
        sb.append(src);
        Class c = JavaShebang.compileClass(m.group("cls"), sb.toString());
        Method main = c.getDeclaredMethod("main", String[].class);
        if (null == main) {
            System.err.println("No main method found");
            System.exit(4);
        }
        main.invoke(null, new Object[]{args});
    }
}

