/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.Body;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.Cookie;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.FilterContext;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.ntlm.NTLMEngineException;
import com.ning.http.client.providers.netty.BodyChunkedInput;
import com.ning.http.client.providers.netty.BodyFileRegion;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.NettyConnectListener;
import com.ning.http.client.providers.netty.NettyConnectionsPool;
import com.ning.http.client.providers.netty.NettyResponse;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.ResponseBodyPart;
import com.ning.http.client.providers.netty.ResponseHeaders;
import com.ning.http.client.providers.netty.ResponseStatus;
import com.ning.http.client.providers.netty.spnego.SpnegoEngine;
import com.ning.http.multipart.MultipartBody;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.CleanupChannelGroup;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpContentDecompressor;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAsyncHttpProvider
extends SimpleChannelUpstreamHandler
implements AsyncHttpProvider {
    private static final String HTTP_HANDLER = "httpHandler";
    static final String SSL_HANDLER = "sslHandler";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final Logger log = LoggerFactory.getLogger(NettyAsyncHttpProvider.class);
    private final ClientBootstrap plainBootstrap;
    private final ClientBootstrap secureBootstrap;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ClientSocketChannelFactory socketChannelFactory;
    private final ChannelGroup openChannels = new CleanupChannelGroup("asyncHttpClient"){

        public boolean remove(Object o) {
            boolean removed = super.remove(o);
            if (removed && NettyAsyncHttpProvider.this.trackConnections) {
                NettyAsyncHttpProvider.this.freeConnections.release();
            }
            return removed;
        }
    };
    private final ConnectionsPool<String, Channel> connectionsPool;
    private Semaphore freeConnections = null;
    private final NettyAsyncHttpProviderConfig asyncHttpProviderConfig;
    private boolean executeConnectAsync = true;
    public static final ThreadLocal<Boolean> IN_IO_THREAD = new ThreadLocalBoolean();
    private final boolean trackConnections;
    private final boolean useRawUrl;
    private static final NTLMEngine ntlmEngine = new NTLMEngine();
    private static final SpnegoEngine spnegoEngine = new SpnegoEngine();

    public NettyAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.asyncHttpProviderConfig = config.getAsyncHttpProviderConfig() != null && NettyAsyncHttpProviderConfig.class.isAssignableFrom(config.getAsyncHttpProviderConfig().getClass()) ? (NettyAsyncHttpProviderConfig)NettyAsyncHttpProviderConfig.class.cast(config.getAsyncHttpProviderConfig()) : new NettyAsyncHttpProviderConfig();
        if (this.asyncHttpProviderConfig.getProperty("useBlockingIO") != null) {
            this.socketChannelFactory = new OioClientSocketChannelFactory((Executor)config.executorService());
        } else {
            Object o = this.asyncHttpProviderConfig.getProperty("bossExecutorService");
            ExecutorService e = o != null && ExecutorService.class.isAssignableFrom(o.getClass()) ? (ExecutorService)ExecutorService.class.cast(o) : Executors.newCachedThreadPool();
            int numWorkers = config.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
            log.info("Number of application's worked threads is {}", (Object)numWorkers);
            this.socketChannelFactory = new NioClientSocketChannelFactory((Executor)e, (Executor)config.executorService(), numWorkers);
        }
        this.plainBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.secureBootstrap = new ClientBootstrap((ChannelFactory)this.socketChannelFactory);
        this.configureNetty();
        this.config = config;
        ConnectionsPool<String, Channel> cp = config.getConnectionsPool();
        if (cp == null && config.getAllowPoolingConnection()) {
            cp = new NettyConnectionsPool(this);
        } else if (cp == null) {
            cp = new NonConnectionsPool();
        }
        this.connectionsPool = cp;
        if (config.getMaxTotalConnections() != -1) {
            this.trackConnections = true;
            this.freeConnections = new Semaphore(config.getMaxTotalConnections());
        } else {
            this.trackConnections = false;
        }
        this.useRawUrl = config.isUseRawUrl();
    }

    public String toString() {
        return String.format("NettyAsyncHttpProvider:\n\t- maxConnections: %d\n\t- openChannels: %s\n\t- connectionPools: %s", this.config.getMaxTotalConnections() - this.freeConnections.availablePermits(), this.openChannels.toString(), this.connectionsPool.toString());
    }

    void configureNetty() {
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.plainBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
        this.plainBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.getRequestCompressionLevel() > 0) {
                    pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor(NettyAsyncHttpProvider.this.config.getRequestCompressionLevel()));
                }
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        DefaultChannelFuture.setUseDeadLockChecker((boolean)false);
        if (this.asyncHttpProviderConfig != null) {
            Object value = this.asyncHttpProviderConfig.getProperty("asyncConnect");
            if (value != null && Boolean.class.isAssignableFrom(value.getClass())) {
                this.executeConnectAsync = (Boolean)Boolean.class.cast(value);
            } else if (this.asyncHttpProviderConfig.getProperty("disableNestedRequest") != null) {
                DefaultChannelFuture.setUseDeadLockChecker((boolean)true);
            }
        }
    }

    void constructSSLPipeline(final NettyConnectListener<?> cl) {
        this.secureBootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                try {
                    pipeline.addLast(NettyAsyncHttpProvider.SSL_HANDLER, (ChannelHandler)new SslHandler(NettyAsyncHttpProvider.this.createSSLEngine()));
                }
                catch (Throwable ex) {
                    NettyAsyncHttpProvider.this.abort(cl.future(), ex);
                }
                pipeline.addLast(NettyAsyncHttpProvider.HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                if (NettyAsyncHttpProvider.this.config.isCompressionEnabled()) {
                    pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("httpProcessor", (ChannelHandler)NettyAsyncHttpProvider.this);
                return pipeline;
            }
        });
        if (this.asyncHttpProviderConfig != null) {
            for (Map.Entry<String, Object> entry : this.asyncHttpProviderConfig.propertiesSet()) {
                this.secureBootstrap.setOption(entry.getKey(), entry.getValue());
            }
        }
    }

    private Channel lookupInCache(URI uri) {
        Channel channel = this.connectionsPool.poll(AsyncHttpProviderUtils.getBaseUrl(uri));
        if (channel != null) {
            log.debug("Using cached Channel {}\n for uri {}\n", (Object)channel, (Object)uri);
            try {
                return this.verifyChannelPipeline(channel, uri.getScheme());
            }
            catch (Exception ex) {
                log.debug(ex.getMessage(), ex);
            }
        }
        return null;
    }

    private SSLEngine createSSLEngine() throws IOException, GeneralSecurityException {
        SSLEngine sslEngine = this.config.getSSLEngineFactory().newSSLEngine();
        if (sslEngine == null) {
            sslEngine = SslUtils.getSSLEngine();
        }
        return sslEngine;
    }

    private Channel verifyChannelPipeline(Channel channel, String scheme) throws IOException, GeneralSecurityException {
        if (channel.getPipeline().get(SSL_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
            channel.getPipeline().remove(SSL_HANDLER);
        } else {
            if (channel.getPipeline().get(HTTP_HANDLER) != null && HTTP.equalsIgnoreCase(scheme)) {
                return channel;
            }
            if (channel.getPipeline().get(SSL_HANDLER) == null && HTTPS.equalsIgnoreCase(scheme)) {
                channel.getPipeline().addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            }
        }
        return channel;
    }

    protected final <T> void writeRequest(Channel channel, AsyncHttpClientConfig config, NettyResponseFuture<T> future, HttpRequest nettyRequest) {
        block35: {
            try {
                if (!channel.isOpen() || !channel.isConnected()) {
                    return;
                }
                Body body = null;
                if (!future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT)) {
                    if (future.getRequest().getBodyGenerator() != null) {
                        try {
                            body = future.getRequest().getBodyGenerator().createBody();
                        }
                        catch (IOException ex) {
                            throw new IllegalStateException(ex);
                        }
                        long length = body.getContentLength();
                        if (length >= 0L) {
                            nettyRequest.setHeader("Content-Length", (Object)length);
                        } else {
                            nettyRequest.setHeader("Transfer-Encoding", (Object)"chunked");
                        }
                    } else {
                        body = null;
                    }
                }
                if (TransferCompletionHandler.class.isAssignableFrom(future.getAsyncHandler().getClass())) {
                    FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
                    for (String s : future.getNettyRequest().getHeaderNames()) {
                        for (String header : future.getNettyRequest().getHeaders(s)) {
                            h.add(s, header);
                        }
                    }
                    ((TransferCompletionHandler)TransferCompletionHandler.class.cast(future.getAsyncHandler())).transferAdapter(new NettyTransferAdapter(h, nettyRequest.getContent(), future.getRequest().getFile()));
                }
                if (future.getAndSetWriteHeaders(true)) {
                    try {
                        channel.write((Object)nettyRequest).addListener((ChannelFutureListener)new ProgressListener(true, future.getAsyncHandler(), future));
                    }
                    catch (Throwable cause) {
                        log.debug(cause.getMessage(), cause);
                        try {
                            channel.close();
                        }
                        catch (RuntimeException ex) {
                            log.debug(ex.getMessage(), ex);
                        }
                        return;
                    }
                }
                if (!future.getAndSetWriteBody(true) || future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT)) break block35;
                if (future.getRequest().getFile() != null) {
                    File file = future.getRequest().getFile();
                    long fileLength = 0L;
                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                    try {
                        ChannelFuture writeFuture;
                        fileLength = raf.length();
                        if (channel.getPipeline().get(SslHandler.class) != null) {
                            writeFuture = channel.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
                        } else {
                            OptimizedFileRegion region = new OptimizedFileRegion(raf, 0L, fileLength);
                            writeFuture = channel.write((Object)region);
                        }
                        writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future));
                        break block35;
                    }
                    catch (IOException ex) {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                }
                if (body != null || future.getRequest().getParts() != null) {
                    ChannelFuture writeFuture;
                    if (future.getRequest().getParts() != null) {
                        String boundary = future.getNettyRequest().getHeader("Content-Type");
                        String length = future.getNettyRequest().getHeader("Content-Length");
                        body = new MultipartBody(future.getRequest().getParts(), boundary, length);
                    }
                    if (channel.getPipeline().get(SslHandler.class) == null && body instanceof RandomAccessBody) {
                        BodyFileRegion bodyFileRegion = new BodyFileRegion((RandomAccessBody)body);
                        writeFuture = channel.write((Object)bodyFileRegion);
                    } else {
                        BodyChunkedInput bodyChunkedInput = new BodyChunkedInput(body);
                        writeFuture = channel.write((Object)bodyChunkedInput);
                    }
                    final Body b = body;
                    writeFuture.addListener((ChannelFutureListener)new ProgressListener(false, future.getAsyncHandler(), future){

                        public void operationComplete(ChannelFuture cf) {
                            try {
                                b.close();
                            }
                            catch (IOException e) {
                                log.warn("Failed to close request body: {}", (Object)e.getMessage(), (Object)e);
                            }
                            super.operationComplete(cf);
                        }
                    });
                }
            }
            catch (Throwable ioe) {
                try {
                    channel.close();
                }
                catch (RuntimeException ex) {
                    log.debug(ex.getMessage(), ex);
                }
            }
        }
        try {
            future.touch();
            int delay = NettyAsyncHttpProvider.requestTimeout(config, future.getRequest().getPerRequestConfig());
            if (delay != -1 && !future.isDone() && !future.isCancelled()) {
                ReaperFuture reaperFuture = new ReaperFuture(channel, future);
                ScheduledFuture<?> scheduledFuture = config.reaper().scheduleAtFixedRate(reaperFuture, 0L, delay, TimeUnit.MILLISECONDS);
                reaperFuture.setScheduledFuture(scheduledFuture);
                future.setReaperFuture(reaperFuture);
            }
        }
        catch (RejectedExecutionException ex) {
            this.abort(future, ex);
        }
    }

    protected static final HttpRequest buildRequest(AsyncHttpClientConfig config, Request request, URI uri, boolean allowConnect, ChannelBuffer buffer) throws IOException {
        String method = request.getMethod();
        if (allowConnect && (request.getProxyServer() != null || config.getProxyServer() != null) && HTTPS.equalsIgnoreCase(uri.getScheme())) {
            method = HttpMethod.CONNECT.toString();
        }
        return NettyAsyncHttpProvider.construct(config, request, new HttpMethod(method), uri, buffer);
    }

    private static HttpRequest construct(AsyncHttpClientConfig config, Request request, HttpMethod m, URI uri, ChannelBuffer buffer) throws IOException {
        boolean avoidProxy;
        Realm realm;
        DefaultHttpRequest nettyRequest;
        String host = uri.getHost();
        if (request.getVirtualHost() != null) {
            host = request.getVirtualHost();
        }
        if (m.equals((Object)HttpMethod.CONNECT)) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_0, m, AsyncHttpProviderUtils.getAuthority(uri));
        } else if (config.getProxyServer() != null || request.getProxyServer() != null) {
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, uri.toString());
        } else {
            StringBuilder path = new StringBuilder(uri.getRawPath());
            if (uri.getQuery() != null) {
                path.append("?").append(uri.getRawQuery());
            }
            nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, m, path.toString());
        }
        if (host != null) {
            if (uri.getPort() == -1) {
                nettyRequest.setHeader("Host", (Object)host);
            } else if (request.getVirtualHost() != null) {
                nettyRequest.setHeader("Host", (Object)host);
            } else {
                nettyRequest.setHeader("Host", (Object)(host + ":" + uri.getPort()));
            }
        } else {
            host = "127.0.0.1";
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            FluentCaseInsensitiveStringsMap h = request.getHeaders();
            if (h != null) {
                for (String name : h.keySet()) {
                    if ("host".equalsIgnoreCase(name)) continue;
                    Iterator i$ = h.get(name).iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        nettyRequest.addHeader(name, (Object)value);
                    }
                }
            }
            if (config.isCompressionEnabled()) {
                nettyRequest.setHeader("Accept-Encoding", (Object)"gzip");
            }
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : config.getProxyServer();
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : config.getRealm();
        if (realm != null && realm.getUsePreemptiveAuth()) {
            String domain = realm.getNtlmDomain();
            if (proxyServer != null && proxyServer.getNtlmDomain() != null) {
                domain = proxyServer.getNtlmDomain();
            }
            String authHost = realm.getNtlmHost();
            if (proxyServer != null && proxyServer.getHost() != null) {
                host = proxyServer.getHost();
            }
            switch (realm.getAuthScheme()) {
                case BASIC: {
                    nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(realm));
                    break;
                }
                case DIGEST: {
                    if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                    try {
                        nettyRequest.setHeader("Authorization", (Object)AuthenticatorUtils.computeDigestAuthentication(realm));
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SecurityException(e);
                    }
                }
                case NTLM: {
                    try {
                        nettyRequest.setHeader("Authorization", (Object)ntlmEngine.generateType1Msg("NTLM " + domain, authHost));
                        break;
                    }
                    catch (NTLMEngineException e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                }
                case KERBEROS: 
                case SPNEGO: {
                    String challengeHeader = null;
                    String server = proxyServer == null ? host : proxyServer.getHost();
                    try {
                        challengeHeader = spnegoEngine.generateToken(server);
                    }
                    catch (Throwable e) {
                        IOException ie = new IOException();
                        ie.initCause(e);
                        throw ie;
                    }
                    nettyRequest.setHeader("Authorization", (Object)("Negotiate " + challengeHeader));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid Authentication %s", realm.toString()));
                }
            }
        }
        if (!request.getHeaders().containsKey("Connection")) {
            nettyRequest.setHeader("Connection", (Object)"keep-alive");
        }
        if (!(avoidProxy = ProxyUtils.avoidProxy(proxyServer, request))) {
            if (!request.getHeaders().containsKey("Proxy-Connection")) {
                nettyRequest.setHeader("Proxy-Connection", (Object)"keep-alive");
            }
            if (proxyServer.getPrincipal() != null) {
                nettyRequest.setHeader("Proxy-Authorization", (Object)AuthenticatorUtils.computeBasicAuthentication(proxyServer));
            }
        }
        if (request.getHeaders().getFirstValue("Accept") == null) {
            nettyRequest.setHeader("Accept", (Object)"*/*");
        }
        if (request.getHeaders().getFirstValue("User-Agent") != null) {
            nettyRequest.setHeader("User-Agent", (Object)request.getHeaders().getFirstValue("User-Agent"));
        } else if (config.getUserAgent() != null) {
            nettyRequest.setHeader("User-Agent", (Object)config.getUserAgent());
        } else {
            nettyRequest.setHeader("User-Agent", (Object)AsyncHttpProviderUtils.constructUserAgent(NettyAsyncHttpProvider.class));
        }
        if (!m.equals((Object)HttpMethod.CONNECT)) {
            String reqType;
            if (request.getCookies() != null && !request.getCookies().isEmpty()) {
                CookieEncoder httpCookieEncoder = new CookieEncoder(false);
                for (Cookie c : request.getCookies()) {
                    DefaultCookie cookie = new DefaultCookie(c.getName(), c.getValue());
                    cookie.setPath(c.getPath());
                    cookie.setMaxAge(c.getMaxAge());
                    cookie.setDomain(c.getDomain());
                    httpCookieEncoder.addCookie((org.jboss.netty.handler.codec.http.Cookie)cookie);
                }
                nettyRequest.setHeader("Cookie", (Object)httpCookieEncoder.encode());
            }
            if (!("GET".equals(reqType = request.getMethod()) || "HEAD".equals(reqType) || "OPTION".equals(reqType) || "TRACE".equals(reqType))) {
                String bodyCharset;
                String string = bodyCharset = request.getBodyEncoding() == null ? "ISO-8859-1" : request.getBodyEncoding();
                if (buffer != null && buffer.writerIndex() != 0) {
                    nettyRequest.setHeader("Content-Length", (Object)buffer.writerIndex());
                    nettyRequest.setContent(buffer);
                } else if (request.getByteData() != null) {
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getByteData().length));
                    nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])request.getByteData()));
                } else if (request.getStringData() != null) {
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(request.getStringData().getBytes(bodyCharset).length));
                    nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])request.getStringData().getBytes(bodyCharset)));
                } else if (request.getStreamData() != null) {
                    int[] lengthWrapper = new int[1];
                    byte[] bytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                    int length = lengthWrapper[0];
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(length));
                    nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])bytes, (int)0, (int)length));
                } else if (request.getParams() != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                        String key = paramEntry.getKey();
                        for (String value : paramEntry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("&");
                            }
                            UTF8UrlEncoder.appendEncoded(sb, key);
                            sb.append("=");
                            UTF8UrlEncoder.appendEncoded(sb, value);
                        }
                    }
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(sb.length()));
                    nettyRequest.setContent(ChannelBuffers.wrappedBuffer((byte[])sb.toString().getBytes(bodyCharset)));
                    if (!request.getHeaders().containsKey("Content-Type")) {
                        nettyRequest.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                    }
                } else if (request.getParts() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
                    nettyRequest.setHeader("Content-Type", (Object)mre.getContentType());
                    nettyRequest.setHeader("Content-Length", (Object)String.valueOf(mre.getContentLength()));
                    if (uri.toString().startsWith(HTTPS)) {
                        ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                        mre.writeRequest((OutputStream)new ChannelBufferOutputStream(b));
                        nettyRequest.setContent(b);
                    }
                } else if (request.getEntityWriter() != null) {
                    int lenght = NettyAsyncHttpProvider.computeAndSetContentLength(request, (HttpRequest)nettyRequest);
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                    request.getEntityWriter().writeEntity((OutputStream)new ChannelBufferOutputStream(b));
                    nettyRequest.setHeader("Content-Length", (Object)b.writerIndex());
                    nettyRequest.setContent(b);
                } else if (request.getFile() != null) {
                    File file = request.getFile();
                    if (!file.isFile()) {
                        throw new IOException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
                    }
                    nettyRequest.setHeader("Content-Length", (Object)file.length());
                }
            }
        }
        return nettyRequest;
    }

    @Override
    public void close() {
        this.isClose.set(true);
        try {
            this.connectionsPool.destroy();
            this.openChannels.close();
            for (Channel channel : this.openChannels) {
                ChannelHandlerContext ctx = channel.getPipeline().getContext(NettyAsyncHttpProvider.class);
                if (!(ctx.getAttachment() instanceof NettyResponseFuture)) continue;
                NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
                future.setReaperFuture(null);
            }
            this.config.executorService().shutdown();
            this.config.reaper().shutdown();
            this.socketChannelFactory.releaseExternalResources();
            this.plainBootstrap.releaseExternalResources();
            this.secureBootstrap.releaseExternalResources();
        }
        catch (Throwable t) {
            log.warn("Unexpected error on close", t);
        }
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(status, headers, bodyParts);
    }

    @Override
    public <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) throws IOException {
        return this.doConnect(request, asyncHandler, null, true, this.executeConnectAsync, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, asyncConnect, false);
    }

    private <T> void execute(Request request, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        this.doConnect(request, f.getAsyncHandler(), f, useCache, asyncConnect, reclaimCache);
    }

    private <T> ListenableFuture<T> doConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> f, boolean useCache, boolean asyncConnect, boolean reclaimCache) throws IOException {
        ChannelFuture channelFuture;
        boolean useSSl;
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        String requestUrl = this.useRawUrl ? request.getRawUrl() : request.getUrl();
        URI uri = AsyncHttpProviderUtils.createUri(requestUrl);
        Channel channel = null;
        if (useCache) {
            channel = f != null && f.reuseChannel() && f.channel() != null ? f.channel() : this.lookupInCache(uri);
        }
        ChannelBuffer bufferedBytes = null;
        if (f != null && f.getRequest().getFile() == null && !f.getNettyRequest().getMethod().getName().equals(HttpMethod.CONNECT.getName())) {
            bufferedBytes = f.getNettyRequest().getContent();
        }
        boolean bl = useSSl = uri.getScheme().compareToIgnoreCase(HTTPS) == 0 && proxyServer == null;
        if (channel != null && channel.isOpen() && channel.isConnected()) {
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, request, uri, false, bufferedBytes);
            if (f == null) {
                f = NettyAsyncHttpProvider.newFuture(uri, request, asyncHandler, nettyRequest, this.config, this);
            } else {
                f.setNettyRequest(nettyRequest);
            }
            f.setState(NettyResponseFuture.STATE.POOLED);
            f.attachChannel(channel, false);
            log.debug("\nUsing cached Channel {}\n for request \n{}\n", (Object)channel, (Object)nettyRequest);
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(f);
            try {
                this.writeRequest(channel, this.config, f, nettyRequest);
            }
            catch (Exception ex) {
                log.debug("writeRequest failure", ex);
                if (useSSl && ex.getMessage() != null && ex.getMessage().contains("SSLEngine")) {
                    log.debug("SSLEngine failure", ex);
                    f = null;
                }
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("doConnect.writeRequest()", t);
                }
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(ex);
                throw ioe;
            }
            return f;
        }
        if (!reclaimCache && !this.connectionsPool.canCacheConnection()) {
            IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
            try {
                asyncHandler.onThrowable(ex);
            }
            catch (Throwable t) {
                log.warn("!connectionsPool.canCacheConnection()", t);
            }
            throw ex;
        }
        boolean acquiredConnection = false;
        if (this.trackConnections && !reclaimCache) {
            if (!this.freeConnections.tryAcquire()) {
                IOException ex = new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
                try {
                    asyncHandler.onThrowable(ex);
                }
                catch (Throwable t) {
                    log.warn("!connectionsPool.canCacheConnection()", t);
                }
                throw ex;
            }
            acquiredConnection = true;
        }
        NettyConnectListener<T> c = new NettyConnectListener.Builder<T>(this.config, request, asyncHandler, f, this, bufferedBytes).build(uri);
        boolean avoidProxy = ProxyUtils.avoidProxy(proxyServer, uri.getHost());
        if (useSSl) {
            this.constructSSLPipeline(c);
        }
        ClientBootstrap bootstrap = useSSl ? this.secureBootstrap : this.plainBootstrap;
        bootstrap.setOption("connectTimeoutMillis", (Object)this.config.getConnectionTimeoutInMs());
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            bootstrap.setOption("reuseAddress", this.asyncHttpProviderConfig.getProperty("reuseAddress"));
        }
        try {
            channelFuture = proxyServer == null || avoidProxy ? bootstrap.connect((SocketAddress)new InetSocketAddress(uri.getHost(), AsyncHttpProviderUtils.getPort(uri))) : bootstrap.connect((SocketAddress)new InetSocketAddress(proxyServer.getHost(), proxyServer.getPort()));
        }
        catch (Throwable t) {
            if (acquiredConnection) {
                this.freeConnections.release();
            }
            this.abort(c.future(), t.getCause() == null ? t : t.getCause());
            return c.future();
        }
        boolean directInvokation = true;
        if (IN_IO_THREAD.get().booleanValue() && DefaultChannelFuture.isUseDeadLockChecker()) {
            directInvokation = false;
        }
        if (directInvokation && !asyncConnect && request.getFile() == null) {
            int timeOut;
            int n = timeOut = this.config.getConnectionTimeoutInMs() > 0 ? this.config.getConnectionTimeoutInMs() : Integer.MAX_VALUE;
            if (!channelFuture.awaitUninterruptibly((long)timeOut, TimeUnit.MILLISECONDS)) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                channelFuture.cancel();
                this.abort(c.future(), new ConnectException(String.format("Connect operation to %s timeout %s", uri, timeOut)));
            }
            try {
                c.operationComplete(channelFuture);
            }
            catch (Exception e) {
                if (acquiredConnection) {
                    this.freeConnections.release();
                }
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                try {
                    asyncHandler.onThrowable(ioe);
                }
                catch (Throwable t) {
                    log.warn("c.operationComplete()", t);
                }
                throw ioe;
            }
        }
        channelFuture.addListener(c);
        log.debug("\nNon cached request \n{}\n\nusing Channel \n{}\n", (Object)c.future().getNettyRequest(), (Object)channelFuture.getChannel());
        if (!c.future().isCancelled() || !c.future().isDone()) {
            this.openChannels.add((Object)channelFuture.getChannel());
            c.future().attachChannel(channelFuture.getChannel(), false);
        }
        return c.future();
    }

    protected static int requestTimeout(AsyncHttpClientConfig config, PerRequestConfig perRequestConfig) {
        int prRequestTimeout;
        int result = perRequestConfig != null ? ((prRequestTimeout = perRequestConfig.getRequestTimeoutInMs()) != 0 ? prRequestTimeout : config.getRequestTimeoutInMs()) : config.getRequestTimeoutInMs();
        return result;
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        this.connectionsPool.removeAll(ctx.getChannel());
        this.finishChannel(ctx);
    }

    private void finishChannel(ChannelHandlerContext ctx) {
        ctx.setAttachment((Object)new DiscardEvent());
        if (ctx.getChannel() == null) {
            return;
        }
        log.debug("Closing Channel {} ", (Object)ctx.getChannel());
        try {
            ctx.getChannel().close();
        }
        catch (Throwable t) {
            log.debug("Error closing a connection", t);
        }
        if (ctx.getChannel() != null) {
            this.openChannels.remove((Object)ctx.getChannel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void messageReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        IN_IO_THREAD.set(Boolean.TRUE);
        if (ctx.getAttachment() == null) {
            log.debug("ChannelHandlerContext wasn't having any attachment");
        }
        if (ctx.getAttachment() instanceof DiscardEvent) {
            return;
        }
        if (ctx.getAttachment() instanceof AsyncCallable) {
            if (e.getMessage() instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)e.getMessage();
                if (!chunk.isLast()) return;
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            } else {
                AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
                ac.call();
            }
            ctx.setAttachment((Object)new DiscardEvent());
            return;
        }
        if (!(ctx.getAttachment() instanceof NettyResponseFuture)) {
            try {
                ctx.getChannel().close();
                return;
            }
            catch (Throwable t) {
                log.trace("Closing an orphan channel {}", (Object)ctx.getChannel());
            }
            return;
        }
        final NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
        future.touch();
        if (future.isCancelled() || future.isDone()) {
            this.finishChannel(ctx);
            return;
        }
        HttpRequest nettyRequest = future.getNettyRequest();
        AsyncHandler handler = future.getAsyncHandler();
        Request request = future.getRequest();
        HttpResponse response = null;
        try {
            if (e.getMessage() instanceof HttpResponse) {
                boolean redirectEnabled;
                response = (HttpResponse)e.getMessage();
                log.debug("\n\nRequest {}\n\nResponse {}\n", (Object)nettyRequest, (Object)response);
                future.setHttpResponse(response);
                int statusCode = response.getStatus().getCode();
                String ka = response.getHeader("Connection");
                future.setKeepAlive(ka == null || ka.toLowerCase().equals("keep-alive"));
                List<String> wwwAuth = this.getAuthorizationToken(response.getHeaders(), "WWW-Authenticate");
                Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
                ResponseStatus status = new ResponseStatus(future.getURI(), response, this);
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(request).responseStatus(status).build();
                for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
                    try {
                        if ((fc = asyncFilter.filter(fc)) != null) continue;
                        throw new NullPointerException("FilterContext is null");
                    }
                    catch (FilterException efe) {
                        this.abort(future, efe);
                    }
                }
                if (fc.replayRequest()) {
                    this.replayRequest(future, fc, response, ctx);
                    return;
                }
                Realm newRealm = null;
                ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
                final FluentCaseInsensitiveStringsMap headers = request.getHeaders();
                final RequestBuilder builder = new RequestBuilder(future.getRequest());
                if (realm != null && !future.getURI().getPath().equalsIgnoreCase(realm.getUri())) {
                    builder.setUrl(future.getURI().toString());
                }
                if (statusCode == 401 && wwwAuth.size() > 0 && !future.getAndSetAuth(true)) {
                    future.setState(NettyResponseFuture.STATE.NEW);
                    if (!wwwAuth.contains("Kerberos") && (wwwAuth.contains("NTLM") || wwwAuth.contains("Negotiate"))) {
                        newRealm = this.ntlmChallenge(wwwAuth, request, proxyServer, headers, realm, future);
                    } else if (wwwAuth.contains("Negotiate")) {
                        newRealm = this.kerberosChallenge(wwwAuth, request, proxyServer, headers, realm, future);
                        if (newRealm == null) {
                            return;
                        }
                    } else {
                        Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()) : new Realm.RealmBuilder();
                        newRealm = realmBuilder.setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).setUsePreemptiveAuth(true).parseWWWAuthenticateHeader(wwwAuth.get(0)).build();
                    }
                    final Realm nr = newRealm;
                    log.debug("Sending authentication to {}", (Object)request.getUrl());
                    AsyncCallable ac = new AsyncCallable(future){

                        public Object call() throws Exception {
                            NettyAsyncHttpProvider.this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
                            NettyAsyncHttpProvider.this.nextRequest(((RequestBuilder)builder.setHeaders(headers).setRealm(nr)).build(), future);
                            return null;
                        }
                    };
                    if (future.getKeepAlive() && response.isChunked()) {
                        ctx.setAttachment((Object)ac);
                        return;
                    } else {
                        ac.call();
                    }
                    return;
                }
                if (statusCode == 100) {
                    future.getAndSetWriteHeaders(false);
                    future.getAndSetWriteBody(true);
                    this.writeRequest(ctx.getChannel(), this.config, future, nettyRequest);
                    return;
                }
                List<String> proxyAuth = this.getAuthorizationToken(response.getHeaders(), "Proxy-Authenticate");
                if (statusCode == 407 && proxyAuth.size() > 0 && !future.getAndSetAuth(true)) {
                    log.debug("Sending proxy authentication to {}", (Object)request.getUrl());
                    future.setState(NettyResponseFuture.STATE.NEW);
                    if (!proxyAuth.contains("Kerberos") && (proxyAuth.contains("NTLM") || proxyAuth.contains("Negotiate"))) {
                        newRealm = this.ntlmChallenge(proxyAuth, request, proxyServer, headers, realm, future);
                    } else if (proxyAuth.contains("Negotiate")) {
                        newRealm = this.kerberosChallenge(proxyAuth, request, proxyServer, headers, realm, future);
                        if (newRealm == null) {
                            return;
                        }
                    } else {
                        newRealm = future.getRequest().getRealm();
                    }
                    this.nextRequest(((RequestBuilder)builder.setHeaders(headers).setRealm(newRealm)).build(), future);
                    return;
                }
                if (future.getNettyRequest().getMethod().equals((Object)HttpMethod.CONNECT) && statusCode == 200) {
                    log.debug("Connected to {}:{}", (Object)proxyServer.getHost(), (Object)proxyServer.getPort());
                    if (future.getKeepAlive()) {
                        future.attachChannel(ctx.getChannel(), true);
                    }
                    try {
                        log.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)request.getUrl());
                        this.upgradeProtocol(ctx.getChannel().getPipeline(), request.getUrl());
                    }
                    catch (Throwable ex) {
                        this.abort(future, ex);
                    }
                    this.nextRequest(builder.build(), future);
                    return;
                }
                boolean bl = redirectEnabled = request.isRedirectEnabled() ? true : this.config.isRedirectEnabled();
                if (redirectEnabled && (statusCode == 302 || statusCode == 301)) {
                    if (future.incrementAndGetCurrentRedirectCount() >= this.config.getMaxRedirects()) throw new MaxRedirectException("Maximum redirect reached: " + this.config.getMaxRedirects());
                    future.getAndSetAuth(false);
                    String location = response.getHeader("Location");
                    URI uri = AsyncHttpProviderUtils.getRedirectUri(future.getURI(), location);
                    boolean stripQueryString = this.config.isRemoveQueryParamOnRedirect();
                    if (!uri.toString().equalsIgnoreCase(future.getURI().toString())) {
                        Cookie c;
                        RequestBuilder nBuilder = stripQueryString ? new RequestBuilder(future.getRequest()).setQueryParameters(null) : new RequestBuilder(future.getRequest());
                        final URI initialConnectionUri = future.getURI();
                        final boolean initialConnectionKeepAlive = future.getKeepAlive();
                        future.setURI(uri);
                        String newUrl = uri.toString();
                        log.debug("Redirecting to {}", (Object)newUrl);
                        for (String cookieStr : future.getHttpResponse().getHeaders("Set-Cookie")) {
                            c = AsyncHttpProviderUtils.parseCookie(cookieStr);
                            nBuilder.addOrReplaceCookie(c);
                        }
                        for (String cookieStr : future.getHttpResponse().getHeaders("Set-Cookie2")) {
                            c = AsyncHttpProviderUtils.parseCookie(cookieStr);
                            nBuilder.addOrReplaceCookie(c);
                        }
                        AsyncCallable ac = new AsyncCallable(future){

                            public Object call() throws Exception {
                                if (initialConnectionKeepAlive && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(AsyncHttpProviderUtils.getBaseUrl(initialConnectionUri), ctx.getChannel())) {
                                    return null;
                                }
                                NettyAsyncHttpProvider.this.finishChannel(ctx);
                                return null;
                            }
                        };
                        if (response.isChunked()) {
                            ctx.setAttachment((Object)ac);
                        } else {
                            ac.call();
                        }
                        this.nextRequest(nBuilder.setUrl(newUrl).build(), future);
                        return;
                    }
                }
                if (!future.getAndSetStatusReceived(true) && this.updateStatusAndInterrupt(handler, status)) {
                    this.finishUpdate(future, ctx, response.isChunked());
                    return;
                }
                if (this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), response, this))) {
                    this.finishUpdate(future, ctx, response.isChunked());
                    return;
                }
                if (!response.isChunked()) {
                    if (response.getContent().readableBytes() != 0) {
                        this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                    }
                    this.finishUpdate(future, ctx, false);
                    return;
                }
                if (!nettyRequest.getMethod().equals((Object)HttpMethod.HEAD)) return;
                this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), response, this));
                this.markAsDone(future, ctx);
                this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
                return;
            }
            if (!(e.getMessage() instanceof HttpChunk)) return;
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (handler == null || !chunk.isLast() && !this.updateBodyAndInterrupt(handler, new ResponseBodyPart(future.getURI(), null, this, chunk))) return;
            if (chunk instanceof DefaultHttpChunkTrailer) {
                this.updateHeadersAndInterrupt(handler, new ResponseHeaders(future.getURI(), future.getHttpResponse(), this, (HttpChunkTrailer)chunk));
            }
            this.finishUpdate(future, ctx, !chunk.isLast());
            return;
        }
        catch (Exception t) {
            if (IOException.class.isAssignableFrom(t.getClass()) && this.config.getIOExceptionFilters().size() > 0) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException((IOException)IOException.class.cast(t)).build();
                if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                    this.replayRequest(future, fc, response, ctx);
                    return;
                }
            }
            try {
                this.abort(future, t);
            }
            finally {
                this.finishUpdate(future, ctx, false);
                throw t;
            }
        }
    }

    private Realm kerberosChallenge(List<String> proxyAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        URI uri = URI.create(request.getUrl());
        String host = request.getVirtualHost() == null ? uri.getHost() : request.getVirtualHost();
        String server = proxyServer == null ? host : proxyServer.getHost();
        try {
            String challengeHeader = spnegoEngine.generateToken(server);
            headers.remove("Authorization");
            headers.add("Authorization", "Negotiate " + challengeHeader);
            Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
            return realmBuilder.setUri(uri.getPath()).setMethodName(request.getMethod()).setScheme(Realm.AuthScheme.KERBEROS).build();
        }
        catch (Throwable throwable) {
            if (proxyAuth.contains("NTLM")) {
                return this.ntlmChallenge(proxyAuth, request, proxyServer, headers, realm, future);
            }
            this.abort(future, throwable);
            return null;
        }
    }

    private Realm ntlmChallenge(List<String> wwwAuth, Request request, ProxyServer proxyServer, FluentCaseInsensitiveStringsMap headers, Realm realm, NettyResponseFuture<?> future) throws NTLMEngineException {
        Realm newRealm;
        String password;
        boolean useRealm = proxyServer == null && realm != null;
        String ntlmDomain = useRealm ? realm.getNtlmDomain() : proxyServer.getNtlmDomain();
        String ntlmHost = useRealm ? realm.getNtlmHost() : proxyServer.getHost();
        String principal = useRealm ? realm.getPrincipal() : proxyServer.getPrincipal();
        String string = password = useRealm ? realm.getPassword() : proxyServer.getPassword();
        if (realm != null && !realm.isNtlmMessageType2Received()) {
            String challengeHeader = ntlmEngine.generateType1Msg(ntlmDomain, ntlmHost);
            headers.add("Authorization", "NTLM " + challengeHeader);
            newRealm = new Realm.RealmBuilder().clone(realm).setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).setNtlmMessageType2Received(true).build();
            future.getAndSetAuth(false);
        } else {
            headers.remove("Authorization");
            if (wwwAuth.get(0).startsWith("NTLM ")) {
                String serverChallenge = wwwAuth.get(0).trim().substring("NTLM ".length());
                String challengeHeader = ntlmEngine.generateType3Msg(principal, password, ntlmDomain, ntlmHost, serverChallenge);
                headers.add("Authorization", "NTLM " + challengeHeader);
            }
            Realm.RealmBuilder realmBuilder = realm != null ? new Realm.RealmBuilder().clone(realm) : new Realm.RealmBuilder();
            newRealm = realmBuilder.setScheme(realm.getAuthScheme()).setUri(URI.create(request.getUrl()).getPath()).setMethodName(request.getMethod()).build();
        }
        return newRealm;
    }

    private void drainChannel(final ChannelHandlerContext ctx, NettyResponseFuture<?> future, final boolean keepAlive, final URI uri) {
        ctx.setAttachment((Object)new AsyncCallable(future){

            public Object call() throws Exception {
                if (keepAlive && ctx.getChannel().isReadable() && NettyAsyncHttpProvider.this.connectionsPool.offer(AsyncHttpProviderUtils.getBaseUrl(uri), ctx.getChannel())) {
                    return null;
                }
                NettyAsyncHttpProvider.this.finishChannel(ctx);
                return null;
            }

            public String toString() {
                return String.format("Draining task for channel %s", ctx.getChannel());
            }
        });
    }

    private FilterContext handleIoException(FilterContext fc, NettyResponseFuture<?> future) {
        for (IOExceptionFilter asyncFilter : this.config.getIOExceptionFilters()) {
            try {
                if ((fc = asyncFilter.filter(fc)) != null) continue;
                throw new NullPointerException("FilterContext is null");
            }
            catch (FilterException efe) {
                this.abort(future, efe);
            }
        }
        return fc;
    }

    private void replayRequest(NettyResponseFuture<?> future, FilterContext fc, HttpResponse response, ChannelHandlerContext ctx) throws IOException {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setState(NettyResponseFuture.STATE.NEW);
        future.touch();
        log.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, (Object)future);
        this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
        this.nextRequest(newRequest, future);
    }

    private List<String> getAuthorizationToken(List<Map.Entry<String, String>> list, String headerAuth) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, String> e : list) {
            if (!e.getKey().equalsIgnoreCase(headerAuth)) continue;
            l.add(e.getValue().trim());
        }
        return l;
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future) throws IOException {
        this.nextRequest(request, future, true);
    }

    private void nextRequest(Request request, NettyResponseFuture<?> future, boolean useCache) throws IOException {
        this.execute(request, future, useCache, true, true);
    }

    private void abort(NettyResponseFuture<?> future, Throwable t) {
        Channel channel = future.channel();
        if (channel != null && this.openChannels.contains((Object)channel)) {
            this.closeChannel(channel.getPipeline().getContext(NettyAsyncHttpProvider.class));
            this.openChannels.remove((Object)channel);
        }
        if (!future.isCancelled() && !future.isDone()) {
            log.debug("Aborting Future {}\n", (Object)future);
            log.debug(t.getMessage(), t);
        }
        future.abort(t);
    }

    private void upgradeProtocol(ChannelPipeline p, String scheme) throws IOException, GeneralSecurityException {
        if (p.get(HTTP_HANDLER) != null) {
            p.remove(HTTP_HANDLER);
        }
        if (scheme.startsWith(HTTPS)) {
            if (p.get(SSL_HANDLER) == null) {
                p.addFirst(HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
                p.addFirst(SSL_HANDLER, (ChannelHandler)new SslHandler(this.createSSLEngine()));
            } else {
                p.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
            }
        } else {
            p.addFirst(HTTP_HANDLER, (ChannelHandler)new HttpClientCodec());
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.isClose.get()) {
            return;
        }
        this.connectionsPool.removeAll(ctx.getChannel());
        try {
            super.channelClosed(ctx, e);
        }
        catch (Exception ex) {
            log.trace("super.channelClosed", ex);
        }
        log.debug("Channel Closed: {} with attachment {}", (Object)e.getChannel(), ctx.getAttachment());
        if (ctx.getAttachment() instanceof AsyncCallable) {
            AsyncCallable ac = (AsyncCallable)ctx.getAttachment();
            ctx.setAttachment(ac.future());
            ac.call();
            return;
        }
        if (ctx.getAttachment() instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)ctx.getAttachment();
            future.touch();
            if (this.config.getIOExceptionFilters().size() > 0) {
                FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                if ((fc = this.handleIoException(fc, future)).replayRequest() && !future.cannotBeReplay()) {
                    this.replayRequest(future, fc, null, ctx);
                    return;
                }
            }
            if (future != null && !future.isDone() && !future.isCancelled()) {
                if (!this.remotelyClosed(ctx.getChannel(), future)) {
                    this.abort(future, new IOException("Remotely Closed " + ctx.getChannel()));
                }
            } else {
                this.closeChannel(ctx);
            }
        }
    }

    protected boolean remotelyClosed(Channel channel, NettyResponseFuture<?> future) {
        if (this.isClose.get()) {
            return false;
        }
        this.connectionsPool.removeAll(channel);
        if (future == null && channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment() != null && NettyResponseFuture.class.isAssignableFrom(channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment().getClass())) {
            future = (NettyResponseFuture)channel.getPipeline().getContext(NettyAsyncHttpProvider.class).getAttachment();
        }
        if (future == null || future.cannotBeReplay()) {
            log.debug("Unable to recover future {}\n", (Object)future);
            return false;
        }
        future.setState(NettyResponseFuture.STATE.RECONNECTED);
        log.debug("Trying to recover request {}\n", (Object)future.getNettyRequest());
        try {
            this.nextRequest(future.getRequest(), future);
            return true;
        }
        catch (IOException iox) {
            future.setState(NettyResponseFuture.STATE.CLOSED);
            future.abort(iox);
            log.error("Remotely Closed, unable to recover", iox);
            return false;
        }
    }

    private void markAsDone(NettyResponseFuture<?> future, ChannelHandlerContext ctx) throws MalformedURLException {
        try {
            future.done(null);
        }
        catch (Throwable t) {
            log.debug(t.getMessage(), t);
        }
        if (!future.getKeepAlive() || !ctx.getChannel().isReadable()) {
            this.closeChannel(ctx);
        }
    }

    private void finishUpdate(NettyResponseFuture<?> future, ChannelHandlerContext ctx, boolean lastValidChunk) throws IOException {
        if (lastValidChunk && future.getKeepAlive()) {
            this.drainChannel(ctx, future, future.getKeepAlive(), future.getURI());
        } else {
            if (future.getKeepAlive() && ctx.getChannel().isReadable() && this.connectionsPool.offer(AsyncHttpProviderUtils.getBaseUrl(future.getURI()), ctx.getChannel())) {
                this.markAsDone(future, ctx);
                return;
            }
            this.finishChannel(ctx);
        }
        this.markAsDone(future, ctx);
    }

    private final boolean updateStatusAndInterrupt(AsyncHandler handler, HttpResponseStatus c) throws Exception {
        return handler.onStatusReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateHeadersAndInterrupt(AsyncHandler handler, HttpResponseHeaders c) throws Exception {
        return handler.onHeadersReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    private final boolean updateBodyAndInterrupt(AsyncHandler handler, HttpResponseBodyPart c) throws Exception {
        return handler.onBodyPartReceived(c) != AsyncHandler.STATE.CONTINUE;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        NettyResponseFuture<?> future;
        Throwable cause;
        block16: {
            Channel channel = e.getChannel();
            cause = e.getCause();
            future = null;
            if (log.isDebugEnabled()) {
                log.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
            }
            try {
                if (cause != null && ClosedChannelException.class.isAssignableFrom(cause.getClass())) {
                    return;
                }
                if (ctx.getAttachment() instanceof NettyResponseFuture) {
                    future = (NettyResponseFuture<?>)ctx.getAttachment();
                    future.attachChannel(null, false);
                    future.touch();
                    if (IOException.class.isAssignableFrom(cause.getClass())) {
                        if (this.config.getIOExceptionFilters().size() > 0) {
                            FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getRequest()).ioException(new IOException("Channel Closed")).build();
                            if ((fc = this.handleIoException(fc, future)).replayRequest()) {
                                this.replayRequest(future, fc, null, ctx);
                                return;
                            }
                        } else {
                            try {
                                ctx.getChannel().close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                        log.debug("Trying to recover from dead Channel: {}", (Object)channel);
                        return;
                    }
                    break block16;
                }
                if (ctx.getAttachment() instanceof AsyncCallable) {
                    future = ((AsyncCallable)ctx.getAttachment()).future();
                }
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        if (future != null) {
            try {
                log.debug("Was unable to recover Future: {}", (Object)future);
                this.abort(future, cause);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
        }
        this.closeChannel(ctx);
        ctx.sendUpstream((ChannelEvent)e);
    }

    protected static boolean abortOnConnectCloseException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("sun.nio.ch.SocketChannelImpl") || !element.getMethodName().equals("checkConnect")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnDisconnectException(Throwable cause) {
        try {
            for (StackTraceElement element : cause.getStackTrace()) {
                if (!element.getClassName().equals("org.jboss.netty.handler.ssl.SslHandler") || !element.getMethodName().equals("channelDisconnected")) continue;
                return true;
            }
            if (cause.getCause() != null) {
                return NettyAsyncHttpProvider.abortOnConnectCloseException(cause.getCause());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    protected static boolean abortOnReadCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("read")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    protected static boolean abortOnWriteCloseException(Throwable cause) {
        for (StackTraceElement element : cause.getStackTrace()) {
            if (!element.getClassName().equals("sun.nio.ch.SocketDispatcher") || !element.getMethodName().equals("write")) continue;
            return true;
        }
        if (cause.getCause() != null) {
            return NettyAsyncHttpProvider.abortOnReadCloseException(cause.getCause());
        }
        return false;
    }

    private static final int computeAndSetContentLength(Request request, HttpRequest r) {
        int length = (int)request.getContentLength();
        if (length == -1 && r.getHeader("Content-Length") != null) {
            length = Integer.valueOf(r.getHeader("Content-Length"));
        }
        if (length >= 0) {
            r.setHeader("Content-Length", (Object)String.valueOf(length));
        }
        return length;
    }

    public static <T> NettyResponseFuture<T> newFuture(URI uri, Request request, AsyncHandler<T> asyncHandler, HttpRequest nettyRequest, AsyncHttpClientConfig config, NettyAsyncHttpProvider provider) {
        NettyResponseFuture<T> f = new NettyResponseFuture<T>(uri, request, asyncHandler, nettyRequest, NettyAsyncHttpProvider.requestTimeout(config, request.getPerRequestConfig()), provider);
        if (request.getHeaders().getFirstValue("Expect") != null && request.getHeaders().getFirstValue("Expect").equalsIgnoreCase("100-Continue")) {
            f.getAndSetWriteBody(false);
        }
        return f;
    }

    protected AsyncHttpClientConfig getConfig() {
        return this.config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonConnectionsPool
    implements ConnectionsPool<String, Channel> {
        private NonConnectionsPool() {
        }

        @Override
        public boolean offer(String uri, Channel connection) {
            return false;
        }

        @Override
        public Channel poll(String uri) {
            return null;
        }

        @Override
        public boolean removeAll(Channel connection) {
            return false;
        }

        @Override
        public boolean canCacheConnection() {
            return true;
        }

        @Override
        public void destroy() {
        }
    }

    private static class NettyTransferAdapter
    extends TransferCompletionHandler.TransferAdapter {
        private final ChannelBuffer content;
        private final FileInputStream file;
        private int byteRead = 0;

        public NettyTransferAdapter(FluentCaseInsensitiveStringsMap headers, ChannelBuffer content, File file) throws IOException {
            super(headers);
            this.content = content;
            this.file = file != null ? new FileInputStream(file) : null;
        }

        public void getBytes(byte[] bytes) {
            if (this.content.writableBytes() != 0) {
                this.content.getBytes(this.byteRead, bytes);
                this.byteRead += bytes.length;
            } else if (this.file != null) {
                try {
                    this.byteRead += this.file.read(bytes);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    public static class OptimizedFileRegion
    implements FileRegion {
        private final FileChannel file;
        private final RandomAccessFile raf;
        private final long position;
        private final long count;
        private long byteWritten;

        public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
            this.raf = raf;
            this.file = raf.getChannel();
            this.position = position;
            this.count = count;
        }

        public long getPosition() {
            return this.position;
        }

        public long getCount() {
            return this.count;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            long count = this.count - position;
            if (count < 0L || position < 0L) {
                throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
            }
            if (count == 0L) {
                return 0L;
            }
            long bw = this.file.transferTo(this.position + position, count, target);
            this.byteWritten += bw;
            if (this.byteWritten == this.raf.length()) {
                this.releaseExternalResources();
            }
            return bw;
        }

        public void releaseExternalResources() {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                log.warn("Failed to close a file.", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        private final boolean defaultValue;

        public ThreadLocalBoolean() {
            this(false);
        }

        public ThreadLocalBoolean(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        protected Boolean initialValue() {
            return this.defaultValue ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AsyncCallable
    implements Callable<Object> {
        private final NettyResponseFuture<?> future;

        public AsyncCallable(NettyResponseFuture<?> future) {
            this.future = future;
        }

        @Override
        public abstract Object call() throws Exception;

        public NettyResponseFuture<?> future() {
            return this.future;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReaperFuture
    implements Future,
    Runnable {
        private Future scheduledFuture;
        private Channel channel;
        private NettyResponseFuture<?> nettyResponseFuture;

        public ReaperFuture(Channel channel, NettyResponseFuture<?> nettyResponseFuture) {
            this.channel = channel;
            this.nettyResponseFuture = nettyResponseFuture;
        }

        public void setScheduledFuture(Future scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.channel = null;
            this.nettyResponseFuture = null;
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        public Object get() throws InterruptedException, ExecutionException {
            return this.scheduledFuture.get();
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public synchronized void run() {
            if (NettyAsyncHttpProvider.this.isClose.get()) {
                this.cancel(true);
                return;
            }
            if (this.nettyResponseFuture != null && this.nettyResponseFuture.hasExpired() && !this.nettyResponseFuture.isDone() && !this.nettyResponseFuture.isCancelled()) {
                log.debug("Request Timeout expired for {}\n", (Object)this.nettyResponseFuture);
                int requestTimeout = NettyAsyncHttpProvider.this.config.getRequestTimeoutInMs();
                PerRequestConfig p = this.nettyResponseFuture.getRequest().getPerRequestConfig();
                if (p != null && p.getRequestTimeoutInMs() != -1) {
                    requestTimeout = p.getRequestTimeoutInMs();
                }
                NettyAsyncHttpProvider.this.abort(this.nettyResponseFuture, new TimeoutException(String.format("No response received after %s", requestTimeout)));
                this.nettyResponseFuture = null;
                this.channel = null;
            }
            if (this.nettyResponseFuture == null || this.nettyResponseFuture.isDone() || this.nettyResponseFuture.isCancelled()) {
                this.cancel(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProgressListener
    implements ChannelFutureProgressListener {
        private final boolean notifyHeaders;
        private final AsyncHandler asyncHandler;
        private final NettyResponseFuture<?> future;

        public ProgressListener(boolean notifyHeaders, AsyncHandler asyncHandler, NettyResponseFuture<?> future) {
            this.notifyHeaders = notifyHeaders;
            this.asyncHandler = asyncHandler;
            this.future = future;
        }

        public void operationComplete(ChannelFuture cf) {
            boolean startPublishing;
            Throwable cause = cf.getCause();
            if (cause != null && this.future.getState() != NettyResponseFuture.STATE.NEW) {
                if (IllegalStateException.class.isAssignableFrom(cause.getClass())) {
                    log.debug(cause.getMessage(), cause);
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                if (ClosedChannelException.class.isAssignableFrom(cause.getClass()) || NettyAsyncHttpProvider.abortOnReadCloseException(cause) || NettyAsyncHttpProvider.abortOnWriteCloseException(cause)) {
                    if (log.isDebugEnabled()) {
                        log.debug(cf.getCause() == null ? "" : cf.getCause().getMessage(), cf.getCause());
                    }
                    try {
                        cf.getChannel().close();
                    }
                    catch (RuntimeException ex) {
                        log.debug(ex.getMessage(), ex);
                    }
                    return;
                }
                this.future.abort(cause);
                return;
            }
            this.future.touch();
            Realm realm = this.future.getRequest().getRealm() != null ? this.future.getRequest().getRealm() : NettyAsyncHttpProvider.this.getConfig().getRealm();
            boolean bl = startPublishing = this.future.isInAuth() || realm == null || realm.getUsePreemptiveAuth();
            if (startPublishing && ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                if (this.notifyHeaders) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                } else {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
            }
        }

        public void operationProgressed(ChannelFuture cf, long amount, long current, long total) {
            this.future.touch();
            if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteProgress(amount, current, total);
            }
        }
    }

    static final class DiscardEvent {
        DiscardEvent() {
        }
    }
}

