/*
 * Decompiled with CFR 0.152.
 */
package org.mdkt.compiler;

import eu.javaexperience.shebang.ShebangTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.mdkt.compiler.CompilationException;
import org.mdkt.compiler.CompiledCode;
import org.mdkt.compiler.DynamicClassLoader;
import org.mdkt.compiler.ExtendedStandardJavaFileManager;
import org.mdkt.compiler.SourceCode;

public class CustomInMemoryJavaCompiler {
    protected JavaCompiler javac;
    protected DynamicClassLoader classLoader;
    protected Iterable<String> options;
    boolean ignoreWarnings = false;
    protected Map<String, SourceCode> sourceCodes = new HashMap<String, SourceCode>();
    protected ExtendedStandardJavaFileManager fileManager;

    protected static DynamicClassLoader createDynamicClassLoader(ClassLoader cl) {
        return new DynamicClassLoader(cl){
            protected List<ClassResourceFile> compiledCodes = new ArrayList<ClassResourceFile>();

            @Override
            public URL getResource(String name) {
                for (ClassResourceFile c : this.compiledCodes) {
                    if (!c.fileMatch(name)) continue;
                    try {
                        return new File(c.fileName).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        ShebangTools.propagateAnyway(e);
                    }
                }
                return super.getResource(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                for (ClassResourceFile c : this.compiledCodes) {
                    if (!c.fileMatch(name)) continue;
                    return new ByteArrayInputStream(c.code.getByteCode());
                }
                return super.getResourceAsStream(name);
            }

            @Override
            public void addCode(CompiledCode cc) {
                this.compiledCodes.add(new ClassResourceFile(cc));
                super.addCode(cc);
            }
        };
    }

    public CustomInMemoryJavaCompiler() {
        this.javac = ToolProvider.getSystemJavaCompiler();
        this.classLoader = CustomInMemoryJavaCompiler.createDynamicClassLoader(ClassLoader.getSystemClassLoader());
    }

    public CustomInMemoryJavaCompiler useParentClassLoader(ClassLoader parent) {
        this.classLoader = CustomInMemoryJavaCompiler.createDynamicClassLoader(parent);
        return this;
    }

    public ClassLoader getClassloader() {
        return this.classLoader;
    }

    public CustomInMemoryJavaCompiler useOptions(String ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public CustomInMemoryJavaCompiler ignoreWarnings() {
        this.ignoreWarnings = true;
        return this;
    }

    public void getCompiledFiles() {
    }

    public Map<String, Class<?>> compileAll() throws Exception {
        if (this.sourceCodes.size() == 0) {
            throw new CompilationException("No source code to compile");
        }
        Collection<SourceCode> compilationUnits = this.sourceCodes.values();
        CompiledCode[] code = new CompiledCode[compilationUnits.size()];
        Iterator<SourceCode> iter = compilationUnits.iterator();
        for (int i = 0; i < code.length; ++i) {
            code[i] = new CompiledCode(iter.next().getClassName());
        }
        DiagnosticCollector collector = new DiagnosticCollector();
        this.fileManager = new ExtendedStandardJavaFileManager(this.javac.getStandardFileManager(null, null, null), this.classLoader);
        JavaCompiler.CompilationTask task = this.javac.getTask(null, this.fileManager, collector, this.options, null, compilationUnits);
        boolean result = task.call();
        if (!result || collector.getDiagnostics().size() > 0) {
            StringBuffer exceptionMsg = new StringBuffer();
            exceptionMsg.append("Unable to compile the source");
            boolean hasWarnings = false;
            boolean hasErrors = false;
            for (Diagnostic d : collector.getDiagnostics()) {
                switch (d.getKind()) {
                    case NOTE: 
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        hasWarnings = true;
                        break;
                    }
                    default: {
                        hasErrors = true;
                    }
                }
                exceptionMsg.append("\n").append("[kind=").append((Object)d.getKind());
                exceptionMsg.append(", ").append("line=").append(d.getLineNumber());
                exceptionMsg.append(", ").append("message=").append(d.getMessage(Locale.US)).append("]");
            }
            if (hasWarnings && !this.ignoreWarnings || hasErrors) {
                throw new CompilationException(exceptionMsg.toString());
            }
        }
        HashMap classes = new HashMap();
        for (String className : this.sourceCodes.keySet()) {
            classes.put(className, this.classLoader.loadClass(className));
        }
        return classes;
    }

    public Class<?> compile(String className, String sourceCode) throws Exception {
        return this.addSource(className, sourceCode).compileAll().get(className);
    }

    public CustomInMemoryJavaCompiler addSource(String className, String sourceCode) throws Exception {
        this.sourceCodes.put(className, new SourceCode(className, sourceCode));
        return this;
    }

    protected static class ClassResourceFile {
        protected CompiledCode code;
        protected int flen;
        protected String fileName;

        public ClassResourceFile(CompiledCode cc) {
            this.code = cc;
            this.fileName = cc.getClassName().replace('.', '/') + ".class";
            this.flen = this.fileName.length();
        }

        public boolean fileMatch(String file) {
            file = ShebangTools.normalizeSlashes(file);
            int l = file.length();
            return file.endsWith(this.fileName) && (l == this.flen || l - 1 == this.flen && file.startsWith("/"));
        }
    }
}

