/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether;

import com.tobedevoured.naether.ClassLoaderException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathClassLoader
extends URLClassLoader {
    private Set<URL> loadedPaths = new HashSet<URL>();

    public PathClassLoader() {
        super(new URL[0]);
    }

    public PathClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
    }

    public boolean addPath(String path) throws MalformedURLException {
        File file = new File(path);
        return this.addPath(file);
    }

    public boolean addPath(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (!this.loadedPaths.contains(url)) {
            super.addURL(url);
            this.loadedPaths.add(url);
            return true;
        }
        return false;
    }

    public Set<URL> getLoadedPaths() {
        return this.loadedPaths;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    public Object newInstance(String name) throws ClassLoaderException {
        return this.newInstance(name, (Object[])null);
    }

    public Object newInstance(String name, Object ... params) throws ClassLoaderException {
        return this.newInstance(name, params, (String[])null);
    }

    public Object newInstance(String name, Object[] params, String[] types) throws ClassLoaderException {
        Constructor<?> constructor;
        Class<?> clazz;
        try {
            clazz = this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoaderException(e);
        }
        ArrayList paramTypes = new ArrayList();
        if (types != null) {
            for (String type : types) {
                try {
                    paramTypes.add(this.loadClass(type));
                }
                catch (ClassNotFoundException e) {
                    throw new ClassLoaderException(e);
                }
            }
        } else if (params != null) {
            for (Object param : params) {
                paramTypes.add(param.getClass());
            }
        }
        if (params != null) {
            try {
                constructor = clazz.getConstructor(paramTypes.toArray(new Class[paramTypes.size()]));
            }
            catch (SecurityException e) {
                throw new ClassLoaderException("Private constructor for " + clazz.getSimpleName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new ClassLoaderException("No such constructor for " + clazz.getSimpleName(), e);
            }
            catch (Exception e) {
                throw new ClassLoaderException("Attempted to access constructor for " + clazz.getSimpleName(), e);
            }
            try {
                return constructor.newInstance(params);
            }
            catch (IllegalArgumentException e) {
                throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
            }
            catch (InstantiationException e) {
                throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
            }
            catch (Exception e) {
                throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
            }
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new ClassLoaderException("Private constructor for " + clazz.getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassLoaderException("No such constructor for " + clazz.getSimpleName(), e);
        }
        catch (Exception e) {
            throw new ClassLoaderException("Attempted to access constructor for " + clazz.getSimpleName(), e);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
        }
        catch (InstantiationException e) {
            throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
        }
        catch (Exception e) {
            throw new ClassLoaderException("Attempted to created new instance of " + clazz.getSimpleName(), e);
        }
    }

    public Object execStaticMethod(String className, String methodName) throws ClassLoaderException {
        return this.execStaticMethod(className, methodName, null);
    }

    public Object execStaticMethod(String className, String methodName, List params) throws ClassLoaderException {
        return this.execStaticMethod(className, methodName, params, null);
    }

    public Object execStaticMethod(String className, String methodName, List params, List<String> paramTypes) throws ClassLoaderException {
        Method method;
        Class<?> clazz;
        try {
            clazz = this.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ClassLoaderException(e);
        }
        ArrayList types = null;
        if (params != null) {
            types = new ArrayList();
            if (paramTypes == null) {
                for (Object param : params) {
                    types.add(param.getClass());
                }
            } else {
                for (String type : paramTypes) {
                    try {
                        types.add(this.loadClass(type));
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassLoaderException(e);
                    }
                }
            }
        }
        if (params != null) {
            try {
                method = clazz.getDeclaredMethod(methodName, types.toArray(new Class[types.size()]));
            }
            catch (SecurityException e) {
                throw new ClassLoaderException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ClassLoaderException(e);
            }
            try {
                return method.invoke(clazz, params.toArray(new Object[params.size()]));
            }
            catch (IllegalArgumentException e) {
                throw new ClassLoaderException(e);
            }
            catch (IllegalAccessException e) {
                throw new ClassLoaderException(e);
            }
            catch (InvocationTargetException e) {
                throw new ClassLoaderException(e);
            }
        }
        try {
            method = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (SecurityException e) {
            throw new ClassLoaderException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassLoaderException(e);
        }
        try {
            return method.invoke(clazz, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ClassLoaderException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClassLoaderException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClassLoaderException(e);
        }
    }
}

