/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.impl;

import com.tobedevoured.naether.DependencyException;
import com.tobedevoured.naether.NaetherException;
import com.tobedevoured.naether.ResolveException;
import com.tobedevoured.naether.URLException;
import com.tobedevoured.naether.api.Naether;
import com.tobedevoured.naether.deploy.DeployArtifact;
import com.tobedevoured.naether.deploy.DeployException;
import com.tobedevoured.naether.deploy.InstallException;
import com.tobedevoured.naether.maven.Project;
import com.tobedevoured.naether.maven.ProjectException;
import com.tobedevoured.naether.repo.RepositoryClient;
import com.tobedevoured.naether.util.Env;
import com.tobedevoured.naether.util.Notation;
import com.tobedevoured.naether.util.RepoBuilder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallationException;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;
import org.sonatype.aether.util.artifact.SubArtifact;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

public class NaetherImpl
implements Naether {
    public static final String MIRROR_ENV = "NAETHER_MIRROR";
    public static final RemoteRepository DEFAULT_REPOSITORY = new RemoteRepository("central", "default", "https://repo1.maven.org/maven2/");
    private static final Logger log = LoggerFactory.getLogger(NaetherImpl.class);
    private String localRepoPath;
    private Set<org.sonatype.aether.graph.Dependency> dependencies = new HashSet<org.sonatype.aether.graph.Dependency>();
    private List<Artifact> buildArtifacts = new ArrayList<Artifact>();
    private Set<RemoteRepository> remoteRepositories = new LinkedHashSet<RemoteRepository>(Arrays.asList(DEFAULT_REPOSITORY));
    private Set<String> repositoryIds = new HashSet<String>(Arrays.asList("central"));
    private PreorderNodeListGenerator preorderedNodeList;

    public NaetherImpl() {
        this.localRepoPath = Env.getLocalRepository();
        String naetherMirror = Env.get(MIRROR_ENV);
        if (naetherMirror != null) {
            this.addRemoteRepository("naetherMirror", "default", naetherMirror);
        }
    }

    @Override
    public void clearDependencies() {
        this.setDependencies(new HashSet<org.sonatype.aether.graph.Dependency>());
    }

    @Override
    public void clearBuildArtifacts() {
        this.setBuildArtifacts(new ArrayList<Artifact>());
    }

    @Override
    public void addBuildArtifact(String notation, String path, String pom) {
        Artifact artifact = new DefaultArtifact(notation);
        artifact = artifact.setFile(new File(path));
        this.buildArtifacts.add(artifact);
        String pomNotation = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "pom" + ":" + artifact.getBaseVersion();
        artifact = new DefaultArtifact(pomNotation);
        artifact = artifact.setFile(new File(pom));
        this.buildArtifacts.add(artifact);
    }

    @Override
    public void addBuildArtifact(String notation, String path) throws NaetherException {
        Artifact artifact = new DefaultArtifact(notation);
        artifact = artifact.setFile(new File(path));
        this.buildArtifacts.add(artifact);
        File tempPom = null;
        try {
            tempPom = File.createTempFile("pom", "xml");
        }
        catch (IOException e) {
            throw new NaetherException("Failed to create temp file", e);
        }
        tempPom.deleteOnExit();
        Project project = new Project();
        project.setGroupId(artifact.getGroupId());
        project.setArtifactId(artifact.getArtifactId());
        project.setVersion(artifact.getBaseVersion());
        try {
            project.writePom(tempPom);
        }
        catch (ProjectException e) {
            throw new NaetherException("Failed to create temp POM", e);
        }
        String pomNotation = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + "pom" + ":" + artifact.getBaseVersion();
        artifact = new DefaultArtifact(pomNotation);
        artifact = artifact.setFile(tempPom);
        this.buildArtifacts.add(artifact);
    }

    @Override
    public void addDependency(String notation) {
        this.addDependency(notation, "compile");
    }

    @Override
    public void addDependency(String notation, String scope) {
        log.debug("Add dep {} {}", (Object)notation, (Object)scope);
        DefaultArtifact artifact = new DefaultArtifact(notation);
        if ("test".equals(artifact.getClassifier()) || "test-jar".equals(artifact.getClassifier())) {
            DefaultArtifactType artifactType = new DefaultArtifactType("test-jar", "jar", "test-jar", null);
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, "jar", artifact.getBaseVersion(), artifactType);
        }
        org.sonatype.aether.graph.Dependency dependency = new org.sonatype.aether.graph.Dependency(artifact, scope);
        this.addDependency(dependency);
    }

    @Override
    public void addDependency(org.sonatype.aether.graph.Dependency dependency) {
        org.sonatype.aether.graph.Dependency newDep = null;
        String classifier = dependency.getArtifact().getClassifier();
        if ("test".equals(classifier) || "test-jar".equals(classifier)) {
            DefaultArtifactType artifactType = new DefaultArtifactType("test-jar", "jar", "test-jar", null);
            Artifact artifact = dependency.getArtifact();
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, "jar", artifact.getBaseVersion(), artifactType);
            newDep = new org.sonatype.aether.graph.Dependency(artifact, dependency.getScope());
        } else {
            newDep = dependency;
        }
        this.dependencies.add(newDep);
    }

    @Override
    public void addDependency(Dependency projectDependency) {
        log.debug("Adding dependency: {}", (Object)projectDependency);
        DefaultArtifact artifact = null;
        if ("test".equals(projectDependency.getType()) || "test-jar".equals(projectDependency.getType())) {
            DefaultArtifactType artifactType = new DefaultArtifactType("test-jar", "jar", "test-jar", null);
            artifact = new DefaultArtifact(projectDependency.getGroupId(), projectDependency.getArtifactId(), null, "jar", projectDependency.getVersion(), artifactType);
        } else {
            artifact = new DefaultArtifact(projectDependency.getGroupId(), projectDependency.getArtifactId(), null, "jar", projectDependency.getVersion());
        }
        org.sonatype.aether.graph.Dependency dependency = new org.sonatype.aether.graph.Dependency(artifact, projectDependency.getScope());
        dependency.setOptional(projectDependency.isOptional());
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        for (org.apache.maven.model.Exclusion projectExclusion : projectDependency.getExclusions()) {
            exclusions.add(new Exclusion(projectExclusion.getGroupId(), projectExclusion.getArtifactId(), "*", "*"));
        }
        log.debug("Exclusion: {}", (Object)exclusions);
        dependency = dependency.setExclusions(exclusions);
        this.dependencies.add(dependency);
    }

    @Override
    public void addDependencies(String pomPath) throws ProjectException {
        this.addDependencies(new Project(pomPath, this.getLocalRepoPath(), this.getRemoteRepositories()), null);
    }

    @Override
    public void addDependencies(String pomPath, List<String> scopes) throws ProjectException {
        this.addDependencies(new Project(pomPath), scopes);
    }

    @Override
    public void addDependencies(Project project) throws ProjectException {
        this.addDependencies(project, (List<String>)null);
    }

    @Override
    public void addDependencies(Project project, List<String> scopes) throws ProjectException {
        for (Dependency dependency : project.getDependencies(scopes)) {
            this.addDependency(dependency);
        }
        for (Repository repo : project.getMavenModel().getRepositories()) {
            this.addRemoteRepository(repo.getId(), repo.getLayout(), repo.getUrl());
        }
    }

    @Override
    public void clearRemoteRepositories() {
        this.setRemoteRepositories(new LinkedHashSet<RemoteRepository>());
    }

    @Override
    public void addRemoteRepositoryByUrl(String url) throws NaetherException {
        try {
            this.addRemoteRepository(RepoBuilder.remoteRepositoryFromUrl(url));
        }
        catch (MalformedURLException e) {
            log.error("Malformed url: {}", (Object)url, (Object)e);
            throw new NaetherException(e);
        }
    }

    @Override
    public void addRemoteRepositoryByUrl(String url, String username, String password) throws URLException {
        RemoteRepository remoteRepo;
        try {
            remoteRepo = RepoBuilder.remoteRepositoryFromUrl(url);
        }
        catch (MalformedURLException e) {
            throw new URLException(e);
        }
        remoteRepo = remoteRepo.setAuthentication(new Authentication(username, password));
        this.addRemoteRepository(remoteRepo);
    }

    @Override
    public final void addRemoteRepository(String id, String type, String url) {
        if (this.repositoryIds.add(id)) {
            this.getRemoteRepositories().add(new RemoteRepository(id, type, url));
        }
    }

    @Override
    public void addRemoteRepository(RemoteRepository remoteRepository) {
        if (this.repositoryIds.add(remoteRepository.getId())) {
            this.getRemoteRepositories().add(remoteRepository);
        }
    }

    @Override
    public void setRemoteRepositories(Set<RemoteRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    @Override
    public Set<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public List<String> getRemoteRepositoryUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        for (RemoteRepository repo : this.getRemoteRepositories()) {
            urls.add(repo.getUrl());
        }
        return urls;
    }

    @Override
    public void resolveDependencies() throws URLException, DependencyException {
        this.resolveDependencies(true, null);
    }

    @Override
    public void resolveDependencies(boolean downloadArtifacts) throws URLException, DependencyException {
        this.resolveDependencies(downloadArtifacts, null);
    }

    @Override
    public void resolveDependencies(boolean downloadArtifacts, Map<String, String> properties) throws URLException, DependencyException {
        CollectResult collectResult;
        log.debug("Resolving Dependencies");
        log.debug("Local Repo Path: {}", (Object)this.localRepoPath);
        if (log.isDebugEnabled()) {
            log.debug("Remote Repositories:");
            for (RemoteRepository repo : this.getRemoteRepositories()) {
                log.debug("  {}", (Object)repo.toString());
            }
        }
        RepositoryClient repoClient = new RepositoryClient(this.getLocalRepoPath());
        if (properties != null) {
            repoClient.setProperties(properties);
        }
        if (this.buildArtifacts.size() > 0) {
            repoClient.setBuildWorkspaceReader(this.buildArtifacts);
        }
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setDependencies(new ArrayList<org.sonatype.aether.graph.Dependency>(this.getDependencies()));
        try {
            collectRequest.addRepository(RepoBuilder.remoteRepositoryFromUrl("file:" + this.getLocalRepoPath()));
        }
        catch (MalformedURLException e) {
            throw new URLException("Failed to add local repo to request", e);
        }
        for (RemoteRepository repo : this.getRemoteRepositories()) {
            collectRequest.addRepository(repo);
        }
        try {
            collectResult = repoClient.collectDependencies(collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new DependencyException(e);
        }
        this.preorderedNodeList = new PreorderNodeListGenerator();
        if (downloadArtifacts) {
            DependencyResult dependencyResult;
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            log.debug("Resolving dependencies to files");
            try {
                dependencyResult = repoClient.resolveDependencies(dependencyRequest);
            }
            catch (DependencyResolutionException e) {
                throw new DependencyException(e);
            }
            dependencyResult.getRoot().accept(this.preorderedNodeList);
        } else {
            collectResult.getRoot().accept(this.preorderedNodeList);
        }
        log.debug("Setting resolved dependencies: {}", (Object)this.getDependencies());
    }

    @Override
    public void deployArtifact(DeployArtifact deployArtifact) throws DeployException {
        log.debug("deploy artifact: {} ", (Object)deployArtifact.getNotation());
        RepositoryClient repoClient = new RepositoryClient(this.getLocalRepoPath());
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.addArtifact(deployArtifact.getJarArtifact());
        if (deployArtifact.getPomArtifact() != null) {
            deployRequest.addArtifact(deployArtifact.getPomArtifact());
        }
        deployRequest.setRepository(deployArtifact.getRemoteRepo());
        log.debug("deploying artifact {}", (Object)deployArtifact.getNotation());
        try {
            repoClient.deploy(deployRequest);
        }
        catch (DeploymentException e) {
            log.error("Failed to deploy artifact", e);
            throw new DeployException(e);
        }
    }

    @Override
    public void install(String notation, String pomPath, String filePath) throws InstallException {
        log.debug("installing artifact: {} ", (Object)notation);
        RepositoryClient repoClient = new RepositoryClient(this.getLocalRepoPath());
        InstallRequest installRequest = new InstallRequest();
        if (filePath != null) {
            DefaultArtifact jarArtifact = new DefaultArtifact(notation);
            jarArtifact = (DefaultArtifact)jarArtifact.setFile(new File(filePath));
            installRequest.addArtifact(jarArtifact);
            if (pomPath != null) {
                SubArtifact pomArtifact = new SubArtifact(jarArtifact, "", "pom");
                pomArtifact = (SubArtifact)pomArtifact.setFile(new File(pomPath));
                installRequest.addArtifact(pomArtifact);
            }
        } else if (pomPath != null) {
            Map<String, String> notationMap = Notation.parse(notation);
            notationMap.put("type", "pom");
            DefaultArtifact pomArtifact = new DefaultArtifact(Notation.generate(notationMap));
            pomArtifact = (DefaultArtifact)pomArtifact.setFile(new File(pomPath));
            installRequest.addArtifact(pomArtifact);
        }
        try {
            repoClient.install(installRequest);
        }
        catch (InstallationException e) {
            log.error("Failed to install artifact", e);
            throw new InstallException(e);
        }
    }

    @Override
    public String getResolvedClassPath() {
        if (this.preorderedNodeList != null) {
            return this.preorderedNodeList.getClassPath();
        }
        return null;
    }

    @Override
    public Collection<org.sonatype.aether.graph.Dependency> currentDependencies() {
        Collection<org.sonatype.aether.graph.Dependency> dependencies = null;
        dependencies = this.preorderedNodeList != null ? this.preorderedNodeList.getDependencies(true) : this.getDependencies();
        return dependencies;
    }

    @Override
    public Set<String> getDependenciesNotation() {
        HashSet<String> notations = new HashSet<String>();
        for (org.sonatype.aether.graph.Dependency dependency : this.currentDependencies()) {
            notations.add(Notation.generate(dependency));
        }
        return notations;
    }

    @Override
    public Map<String, Map> getDependenciesGraph() {
        HashMap<String, Map> graph = new HashMap<String, Map>();
        if (this.preorderedNodeList != null) {
            List<DependencyNode> nodes = this.preorderedNodeList.getNodes();
            HashSet<String> notations = new HashSet<String>();
            for (org.sonatype.aether.graph.Dependency dependency : this.getDependencies()) {
                notations.add(Notation.generate(dependency));
            }
            for (DependencyNode node : nodes) {
                String notation = Notation.generate(node.getDependency().getArtifact());
                if (!notations.contains(notation)) continue;
                graph.put(notation, this.mapDependenciesFromNode(node));
            }
        }
        return graph;
    }

    private Map<String, Map> mapDependenciesFromNode(DependencyNode node) {
        HashMap<String, Map> graph = new HashMap<String, Map>();
        for (DependencyNode child : node.getChildren()) {
            String notation = Notation.generate(child.getDependency().getArtifact());
            graph.put(notation, this.mapDependenciesFromNode(child));
        }
        return graph;
    }

    @Override
    public Map<String, String> getDependenciesPath() {
        HashMap<String, String> dependenciesMap = new HashMap<String, String>();
        for (org.sonatype.aether.graph.Dependency dependency : this.currentDependencies()) {
            if (dependency.getArtifact().getFile() == null) continue;
            dependenciesMap.put(Notation.generate(dependency), dependency.getArtifact().getFile().getAbsolutePath());
        }
        return dependenciesMap;
    }

    @Override
    public void setLocalRepoPath(String repoPath) {
        this.localRepoPath = repoPath;
    }

    @Override
    public String getLocalRepoPath() {
        return this.localRepoPath;
    }

    @Override
    public void setDependencies(Set<org.sonatype.aether.graph.Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public Set<org.sonatype.aether.graph.Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Artifact> getBuildArtifacts() {
        return this.buildArtifacts;
    }

    @Override
    public void setBuildArtifacts(List<Artifact> buildArtifacts) {
        this.buildArtifacts = buildArtifacts;
    }

    @Override
    public List<File> downloadArtifacts(List artifactsOrNotations) throws NaetherException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Object artifactsOrNotation : artifactsOrNotations) {
            if (artifactsOrNotation != null) {
                if (artifactsOrNotation instanceof String) {
                    artifacts.add(new DefaultArtifact((String)artifactsOrNotation));
                    continue;
                }
                if (artifactsOrNotation instanceof Artifact) {
                    artifacts.add((Artifact)artifactsOrNotation);
                    continue;
                }
                throw new NaetherException("Only String notations or Artifact instances allowed. Found " + artifactsOrNotation.getClass());
            }
            log.warn("Null found in list of artifacts to download");
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact artifact : artifacts) {
            log.debug("Downloading {}", (Object)artifact);
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact(artifact);
            for (RemoteRepository repo : this.getRemoteRepositories()) {
                artifactRequest.addRepository(repo);
            }
            RepositoryClient repoClient = new RepositoryClient(this.getLocalRepoPath());
            ArtifactResult artifactResult = null;
            try {
                artifactResult = repoClient.resolveArtifact(artifactRequest);
            }
            catch (ArtifactResolutionException e) {
                throw new ResolveException(e);
            }
            Artifact downloadedArtifact = artifactResult.getArtifact();
            files.add(downloadedArtifact.getFile());
        }
        return files;
    }
}

