/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.maven;

import com.tobedevoured.naether.NaetherException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoker {
    private static final Logger logger = LoggerFactory.getLogger(Invoker.class);
    private DefaultInvoker invoker = new DefaultInvoker();

    public Invoker(String localRepo, String mavenHome) {
        this.invoker.setLocalRepositoryDirectory(new File(localRepo));
        if (mavenHome != null) {
            this.invoker.setMavenHome(new File(mavenHome));
        }
    }

    public InvocationResult execute(String pom, String ... goals) throws NaetherException {
        return this.execute(pom, Arrays.asList(goals));
    }

    public InvocationResult execute(String pom, List<String> goals) throws NaetherException {
        if (pom == null) {
            throw new NaetherException("Pom path cannot be null");
        }
        if (goals == null) {
            throw new NaetherException("List<String> of goals cannot be null");
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(pom));
        request.setInteractive(false);
        request.setGoals(goals);
        logger.debug("Running {} goals: {}", (Object)pom, (Object)goals);
        try {
            return this.invoker.execute(request);
        }
        catch (MavenInvocationException e) {
            throw new NaetherException("Failed to execute " + pom + " goals: " + StringUtils.join(goals.iterator(), " "), e);
        }
    }
}

