/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.maven;

import com.tobedevoured.naether.impl.NaetherImpl;
import com.tobedevoured.naether.maven.NaetherModelResolver;
import com.tobedevoured.naether.maven.ProjectException;
import com.tobedevoured.naether.repo.RepositoryClient;
import com.tobedevoured.naether.util.Env;
import com.tobedevoured.naether.util.Notation;
import com.tobedevoured.naether.util.RepoBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.RemoteRepository;

public class Project {
    private static Logger log = LoggerFactory.getLogger(Project.class);
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+)\\}");
    private Model mavenModel;
    private String basePath;

    public Project() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setPackaging("jar");
        this.mavenModel = model;
        this.setBasePath(new File("."));
    }

    public Project(String pomPath) throws ProjectException {
        this(pomPath, null, null);
    }

    public Project(String pomPath, String localRepo, Collection<RemoteRepository> remoteRepos) throws ProjectException {
        if (localRepo == null) {
            localRepo = Env.getLocalRepository();
        }
        if (remoteRepos == null) {
            remoteRepos = Arrays.asList(NaetherImpl.DEFAULT_REPOSITORY);
        }
        this.mavenModel = Project.loadPOM(pomPath, localRepo, remoteRepos);
        this.mavenModel.setPomFile(new File(pomPath));
        File parent = new File(pomPath).getParentFile();
        if (parent != null) {
            this.setBasePath(new File(pomPath).getParentFile());
        } else {
            this.setBasePath(new File("."));
        }
    }

    public static Model loadPOM(String pomPath, String localRepo, Collection<RemoteRepository> repositories) throws ProjectException {
        RepositoryClient repoClient = new RepositoryClient(localRepo);
        NaetherModelResolver resolver = new NaetherModelResolver(repoClient, repositories);
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setProcessPlugins(false);
        req.setPomFile(new File(pomPath));
        req.setModelResolver(resolver);
        req.setValidationLevel(0);
        DefaultModelBuilder builder = new DefaultModelBuilderFactory().newInstance();
        try {
            return builder.build(req).getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new ProjectException("Failed to build project from pom", e);
        }
    }

    public String getVersion() {
        String version = this.getMavenModel().getVersion();
        if (version == null && this.getMavenModel().getParent() != null) {
            version = this.getMavenModel().getParent().getVersion();
        }
        return version;
    }

    public void setVersion(String version) {
        this.getMavenModel().setVersion(version);
    }

    public String getArtifactId() {
        return this.getMavenModel().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        this.getMavenModel().setArtifactId(artifactId);
    }

    public String getGroupId() {
        return this.getMavenModel().getGroupId();
    }

    public void setGroupId(String groupId) {
        this.getMavenModel().setGroupId(groupId);
    }

    public String getType() {
        return this.getMavenModel().getPackaging();
    }

    public void setType(String type) {
        this.getMavenModel().setPackaging(type);
    }

    public void addRepository(String url) throws ProjectException {
        List<Repository> repositories = this.getRepositories();
        if (repositories == null) {
            repositories = new ArrayList<Repository>();
        }
        try {
            Repository repository = RepoBuilder.repositoryFromUrl(url);
            repositories.add(repository);
        }
        catch (MalformedURLException e) {
            throw new ProjectException(e);
        }
        this.getMavenModel().setRepositories(repositories);
    }

    public void setRepositories(List<String> urls) throws ProjectException {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (String url : urls) {
            try {
                Repository repository = RepoBuilder.repositoryFromUrl(url);
                repositories.add(repository);
            }
            catch (MalformedURLException e) {
                throw new ProjectException(e);
            }
        }
        this.getMavenModel().setRepositories(repositories);
    }

    public List<Repository> getRepositories() {
        return this.getMavenModel().getRepositories();
    }

    public List<String> getRepositoryUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        for (Repository repo : this.getRepositories()) {
            urls.add(repo.getUrl());
        }
        return urls;
    }

    public String getProjectNotation() {
        return Notation.generate(this);
    }

    public void setProjectNotation(String notation) {
        Map<String, String> notationMap = Notation.parse(notation);
        this.setGroupId(notationMap.get("groupId"));
        this.setArtifactId(notationMap.get("artifactId"));
        this.setType(notationMap.get("type"));
        this.setVersion(notationMap.get("version"));
    }

    public List<org.apache.maven.model.Dependency> getDependencies() {
        return this.getDependencies(null);
    }

    public List<org.apache.maven.model.Dependency> getDependencies(List<String> scopes) {
        log.debug("Valid scopes: {}", (Object)scopes);
        ArrayList<org.apache.maven.model.Dependency> dependencies = new ArrayList<org.apache.maven.model.Dependency>();
        for (org.apache.maven.model.Dependency dependency : this.getMavenModel().getDependencies()) {
            log.debug("Project properties: {} ", (Object)this.mavenModel.getProperties());
            String artifactId = this.substituteProperty(dependency.getArtifactId());
            String groupId = this.substituteProperty(dependency.getGroupId());
            String version = this.substituteProperty(dependency.getVersion());
            String type = this.substituteProperty(dependency.getType());
            String classifier = this.substituteProperty(dependency.getClassifier());
            String systemPath = this.substituteProperty(dependency.getSystemPath());
            dependency.setSystemPath(systemPath);
            dependency.setArtifactId(artifactId);
            dependency.setGroupId(groupId);
            dependency.setVersion(version);
            dependency.setType(type);
            dependency.setClassifier(classifier);
            dependencies.add(dependency);
        }
        if (scopes == null) {
            scopes = Arrays.asList("compile", "runtime");
        }
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            org.apache.maven.model.Dependency dependency;
            dependency = (org.apache.maven.model.Dependency)iterator.next();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            if (scopes.contains(scope)) continue;
            log.debug("Removing {} with scope {}", (Object)dependency, (Object)dependency.getScope());
            iterator.remove();
        }
        return dependencies;
    }

    public List<String> getDependenciesNotation() {
        return this.getDependenciesNotation(null);
    }

    public List<String> getDependenciesNotation(List<String> scopes) {
        ArrayList<String> notations = new ArrayList<String>();
        for (org.apache.maven.model.Dependency dependency : this.getDependencies(scopes)) {
            notations.add(Notation.generate(dependency));
        }
        return notations;
    }

    public void addDependency(org.apache.maven.model.Dependency dependency) {
        this.mavenModel.addDependency(dependency);
    }

    public void addDependency(String notation) {
        this.addDependency(notation, "compile");
    }

    public void addDependency(String notation, String scope) {
        Map<String, String> notationMap = Notation.parse(notation);
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId(notationMap.get("groupId"));
        dependency.setArtifactId(notationMap.get("artifactId"));
        dependency.setType(notationMap.get("type"));
        dependency.setVersion(notationMap.get("version"));
        dependency.setScope(scope);
        this.addDependency(dependency);
    }

    public void addDependency(Dependency aetherDep) {
        Artifact artifact = aetherDep.getArtifact();
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setType(artifact.getExtension());
        dependency.setVersion(artifact.getVersion());
        dependency.setScope(aetherDep.getScope());
        this.addDependency(dependency);
    }

    public void setDependencies(Collection<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            this.addDependency(dep);
        }
    }

    public void setMavenModel(Model mavenModel) {
        this.mavenModel = mavenModel;
    }

    public Model getMavenModel() {
        return this.mavenModel;
    }

    public void addProperty(String property, String value) {
        this.mavenModel.getProperties().put(property, value);
    }

    public void removeProperty(String property) {
        this.mavenModel.getProperties().remove(property);
    }

    private String substituteProperty(String field) {
        if (field != null) {
            String property = null;
            Matcher matcher = PROPERTY_PATTERN.matcher(field);
            while (matcher.find()) {
                property = matcher.group(1);
            }
            if (property != null) {
                log.debug("Set property {} to {}", (Object)property, (Object)this.getMavenModel().getProperties().getProperty(property));
                return this.getMavenModel().getProperties().getProperty(property);
            }
            return field;
        }
        return null;
    }

    public File getPomFile() {
        return this.mavenModel.getPomFile();
    }

    public void writePom(String filePath) throws ProjectException {
        this.writePom(new File(filePath));
    }

    public void writePom(File file) throws ProjectException {
        BufferedWriter writer;
        log.debug("Writing pom: {}", (Object)file.getPath());
        Project copy = this;
        copy.removeProperty("project.basedir");
        try {
            writer = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new ProjectException(e);
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write(writer, copy.mavenModel);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write pom", e);
        }
    }

    public String toXml() throws ProjectException {
        log.debug("Writing xml");
        Project copy = this;
        copy.removeProperty("project.basedir");
        StringWriter writer = new StringWriter();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try {
            pomWriter.write(writer, copy.mavenModel);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to create pom xml", e);
        }
        writer.flush();
        return writer.toString();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public final void setBasePath(File basePath) {
        this.basePath = basePath.getAbsolutePath();
        this.addProperty("project.basedir", this.basePath);
    }

    public String getFinalName() {
        if (this.mavenModel.getBuild() != null) {
            return this.mavenModel.getBuild().getFinalName();
        }
        return null;
    }
}

