/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.model.Repository;
import org.sonatype.aether.repository.RemoteRepository;

public final class RepoBuilder {
    private RepoBuilder() {
    }

    public static RemoteRepository remoteRepositoryFromUrl(String url) throws MalformedURLException {
        URL parsedUrl = new URL(url);
        StringBuffer id = new StringBuffer(parsedUrl.getHost());
        String path = parsedUrl.getPath();
        if (path.length() > 0) {
            path = path.replaceFirst("/", "").replaceAll("/", "-").replaceAll(":", "-");
            id.append("-");
            id.append(path);
        }
        if (parsedUrl.getPort() > -1) {
            id.append("-");
            id.append(parsedUrl.getPort());
        }
        return new RemoteRepository(id.toString(), "default", url);
    }

    public static Repository repositoryFromUrl(String url) throws MalformedURLException {
        URL parsedUrl = new URL(url);
        StringBuffer id = new StringBuffer(parsedUrl.getHost());
        String path = parsedUrl.getPath();
        if (path.length() > 0) {
            path = path.replaceFirst("/", "").replaceAll("/", "-").replaceAll(":", "-");
            id.append("-");
            id.append(path);
        }
        if (parsedUrl.getPort() > -1) {
            id.append("-");
            id.append(parsedUrl.getPort());
        }
        Repository repo = new Repository();
        repo.setId(id.toString());
        repo.setName(parsedUrl.getHost());
        repo.setUrl(url);
        return repo;
    }
}

