/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.preview;

import eu.javaexperience.calcad.lib.Cal;
import eu.javaexperience.calcad.lib.preview.CalCadInspectionNavigator;
import eu.javaexperience.reflect.Mirror;
import eu.mihosoft.jcsg.Bounds;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.MeshContainer;
import eu.mihosoft.vvecmath.Vector3d;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.concurrent.Semaphore;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.MeshView;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CalCadInspector {
    protected JFrame frame = new JFrame();
    protected JPanel topPanel = new JPanel();
    protected JPanel bottomPanel = new JPanel();
    protected JPanel leftPanel = new JPanel();
    protected JPanel rightPanel = new JPanel();
    protected JFXPanel fxPanel = new JFXPanel();
    protected CalCadInspectionNavigator nav;
    protected PerspectiveCamera perspectiveCamera = new PerspectiveCamera();
    protected ParallelCamera parallelCamera = new ParallelCamera();
    protected Group viewGroup = new Group();
    protected Scene scene = new Scene((Parent)this.viewGroup, 1024.0, 768.0, true);
    protected CSG csg;
    protected MeshContainer mc;

    public CalCadInspector() {
        this.createLayout();
        this.viewGroup.setAutoSizeChildren(true);
        this.scene.setCamera((Camera)this.perspectiveCamera);
        this.scene.setFill((Paint)Color.LIGHTGRAY);
        this.nav = this.addNavigationBehavior(this.fxPanel, this.viewGroup);
        Platform.runLater(() -> this.fxPanel.setScene(this.scene));
    }

    protected void createLayout() {
        this.frame.setLayout(new BorderLayout(1, 1));
        this.topPanel.setLayout(new FlowLayout());
        this.bottomPanel.setLayout(new FlowLayout());
        this.leftPanel.setLayout(new FlowLayout());
        this.rightPanel.setLayout(new FlowLayout());
        this.frame.add((Component)this.topPanel, "First");
        this.frame.add((Component)this.fxPanel, "Center");
        this.frame.add((Component)this.bottomPanel, "Last");
        this.frame.add((Component)this.leftPanel, "Before");
        this.frame.add((Component)this.rightPanel, "After");
        this.frame.setSize(1024, 768);
    }

    public void setInspectorVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public JFrame getWindow() {
        return this.frame;
    }

    public void show(CSG csg) {
        this.show(csg, false);
    }

    public void show(CSG csg, boolean waitShow) {
        Semaphore s = waitShow ? new Semaphore(0) : null;
        Platform.runLater(() -> {
            this.doShow(csg);
            if (null != s) {
                s.release(Integer.MAX_VALUE);
            }
        });
        if (null != s) {
            try {
                s.acquire();
            }
            catch (InterruptedException e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
    }

    public CSG getShownObject() {
        return this.csg;
    }

    protected void doShow(CSG csg) {
        this.csg = csg;
        this.viewGroup.getChildren().clear();
        this.mc = csg.toJavaFXMesh();
        double length = 100.0;
        double thread = 0.5;
        this.viewGroup.getChildren().add((Object)CalCadInspector.toMesh(Cal.cube(length, thread, thread), Color.RED));
        this.viewGroup.getChildren().add((Object)CalCadInspector.toMesh(Cal.cube(thread, length, thread), Color.GREEN));
        this.viewGroup.getChildren().add((Object)CalCadInspector.toMesh(Cal.cube(thread, thread, length), Color.BLUE));
        this.viewGroup.getChildren().add((Object)CalCadInspector.toMesh(this.mc, Color.GREENYELLOW));
    }

    protected static MeshView toMesh(MeshContainer obj, Color c) {
        MeshView meshView = (MeshView)obj.getAsMeshViews().get(0);
        meshView.setCullFace(CullFace.BACK);
        meshView.setMaterial((Material)new PhongMaterial(c));
        return meshView;
    }

    protected static MeshView toMesh(CSG obj, Color c) {
        return CalCadInspector.toMesh(obj.toJavaFXMesh(), c);
    }

    public Bounds determineObjectDimensions() {
        if (null == this.mc) {
            return null;
        }
        return this.mc.getBounds();
    }

    protected static double dist(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public void viewIsometric() {
        Bounds bs = this.determineObjectDimensions();
        if (null == bs) {
            return;
        }
        Vector3d min = bs.getMin();
        Vector3d max = bs.getMax();
        this.nav.rotateZ.setAngle(-135.0);
        this.nav.rotateX.setAngle(135.0);
        double sx = max.getX() - min.getX();
        double sy = max.getY() - min.getY();
        double sz = max.getZ() - min.getZ();
        double size = Math.sqrt(sx * sx + sy * sy + sz * sz);
        double fmin = Math.min(this.frame.getWidth(), this.frame.getHeight());
        double scale = fmin / size;
        this.nav.setScale(scale *= 0.8);
        Vector3d c = bs.getCenter();
        double ox = -c.getX() + c.getY();
        double oy = -c.getX() - c.getY() + c.getZ();
        this.nav.translate.setX((double)(this.frame.getWidth() / 2) - (ox *= scale) / 2.0);
        this.nav.translate.setY((double)(this.frame.getHeight() / 2) + (oy *= scale) / 2.0);
    }

    public static CalCadInspector openNewWindow(String title, int width, int height, CSG object) {
        CalCadInspector cci = new CalCadInspector();
        if (null != title) {
            cci.frame.setTitle(title);
        }
        if (width > 0 && height > 0) {
            cci.frame.setSize(width, height);
        }
        if (null != object) {
            cci.show(object);
        }
        cci.viewIsometric();
        cci.setInspectorVisible(true);
        return cci;
    }

    public CalCadInspectionNavigator getNavigator() {
        return this.nav;
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    public JPanel getLeftPanel() {
        return this.leftPanel;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    protected CalCadInspectionNavigator addNavigationBehavior(JFXPanel fxPanel, Group grp) {
        CalCadInspectionNavigator nav = new CalCadInspectionNavigator((Node)grp, MouseButton.PRIMARY, MouseButton.MIDDLE);
        nav.installListeners((JComponent)fxPanel);
        return nav;
    }

    public void setExitOnClose() {
        this.frame.setDefaultCloseOperation(3);
    }

    public static void addViewHotkeys(CalCadInspector inspector) {
        inspector.nav.getKeyTypeMediator().addEventListener(e -> {
            if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown())) {
                switch (e.getKeyChar()) {
                    case '0': {
                        inspector.resetView();
                        break;
                    }
                    case '5': {
                        inspector.viewIsometric();
                        break;
                    }
                    case 'p': {
                        System.out.println("View informations:");
                        System.out.println("3D Screen: " + inspector.scene.getWidth() + "x" + inspector.scene.getHeight());
                        System.out.println("Translate: " + inspector.nav.translate);
                        System.out.println("Rotate: X: " + inspector.nav.rotateX.getAngle() + ", Z: " + inspector.nav.rotateZ.getAngle());
                        System.out.println("Scale: " + inspector.nav.scale);
                        break;
                    }
                    case 'c': {
                        inspector.switchCamera();
                    }
                }
            }
        });
    }

    public void switchCamera() {
        if (this.parallelCamera == this.scene.getCamera()) {
            this.scene.setCamera((Camera)this.perspectiveCamera);
        } else {
            this.scene.setCamera((Camera)this.parallelCamera);
            this.parallelCamera.setFarClip(1000.0);
        }
    }

    public void setCameraParallel() {
        this.scene.setCamera((Camera)this.parallelCamera);
    }

    public void setCameraPerspective() {
        this.scene.setCamera((Camera)this.perspectiveCamera);
    }

    public void resetView() {
        this.nav.rotateZ.setAngle(0.0);
        this.nav.rotateX.setAngle(0.0);
        this.nav.setScale(1.0);
        this.nav.translate.setX(0.0);
        this.nav.translate.setY(0.0);
    }
}

