/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.triangulate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EarCut {
    public static void earcut(List<Integer> triangles, float[] data, int dataLen, int[] holeIndices, int dim) {
        boolean hasHoles = holeIndices != null && holeIndices.length > 0;
        int outerLen = hasHoles ? holeIndices[0] * dim : dataLen;
        Node outerNode = EarCut.linkedList(data, 0, outerLen, dim, true);
        if (outerNode == null || outerNode.next == outerNode.prev) {
            return;
        }
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float invSize = 0.0f;
        if (hasHoles) {
            outerNode = EarCut.eliminateHoles(data, holeIndices, outerNode, dim);
        }
        if (data.length > 80 * dim) {
            minX = maxX = data[0];
            minY = maxY = data[1];
            for (int i = dim; i < outerLen; i += dim) {
                float x = data[i];
                float y = data[i + 1];
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(y > maxY)) continue;
                maxY = y;
            }
            invSize = Math.max(maxX - minX, maxY - minY);
            invSize = invSize != 0.0f ? 1.0f / invSize : 0.0f;
        }
        EarCut.earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);
    }

    private static Node linkedList(float[] data, int start, int end, int dim, boolean clockwise) {
        Node last = null;
        if (clockwise == EarCut.signedArea(data, start, end, dim) > 0.0f) {
            for (int i = start; i < end; i += dim) {
                last = EarCut.insertNode(i, data[i], data[i + 1], last);
            }
        } else {
            for (int i = end - dim; i >= start; i -= dim) {
                last = EarCut.insertNode(i, data[i], data[i + 1], last);
            }
        }
        if (last != null && EarCut.equals(last, last.next)) {
            EarCut.removeNode(last);
            last = last.next;
        }
        return last;
    }

    private static Node filterPoints(Node start, Node end) {
        boolean again;
        if (start == null) {
            return null;
        }
        if (end == null) {
            end = start;
        }
        Node p = start;
        do {
            again = false;
            if (!p.steiner && (EarCut.equals(p, p.next) || EarCut.area(p.prev, p, p.next) == 0.0f)) {
                EarCut.removeNode(p);
                p = end = p.prev;
                if (p == p.next) break;
                again = true;
                continue;
            }
            p = p.next;
        } while (again || p != end);
        return end;
    }

    private static void earcutLinked(Node ear, List<Integer> triangles, int dim, float minX, float minY, float invSize, int pass) {
        if (ear == null) {
            return;
        }
        if (pass == 0 && invSize != 0.0f) {
            EarCut.indexCurve(ear, minX, minY, invSize);
        }
        Node stop = ear;
        while (ear.prev != ear.next) {
            Node prev = ear.prev;
            Node next = ear.next;
            if (invSize != 0.0f ? EarCut.isEarHashed(ear, minX, minY, invSize) : EarCut.isEar(ear)) {
                triangles.add(prev.i / dim);
                triangles.add(ear.i / dim);
                triangles.add(next.i / dim);
                EarCut.removeNode(ear);
                ear = next.next;
                stop = next.next;
                continue;
            }
            ear = next;
            if (ear != stop) continue;
            if (pass == 0) {
                EarCut.earcutLinked(EarCut.filterPoints(ear, null), triangles, dim, minX, minY, invSize, 1);
                break;
            }
            if (pass == 1) {
                ear = EarCut.cureLocalIntersections(EarCut.filterPoints(ear, null), triangles, dim);
                EarCut.earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
                break;
            }
            if (pass != 2) break;
            EarCut.splitEarcut(ear, triangles, dim, minX, minY, invSize);
            break;
        }
    }

    private static boolean isEar(Node ear) {
        Node a = ear.prev;
        Node b = ear;
        Node c = ear.next;
        if (EarCut.area(a, b, c) >= 0.0f) {
            return false;
        }
        Node p = ear.next.next;
        while (p != ear.prev) {
            if (EarCut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && EarCut.area(p.prev, p, p.next) >= 0.0f) {
                return false;
            }
            p = p.next;
        }
        return true;
    }

    private static boolean isEarHashed(Node ear, float minX, float minY, float invSize) {
        float maxTX;
        float minTY;
        float minTX;
        Node a = ear.prev;
        Node b = ear;
        Node c = ear.next;
        if (EarCut.area(a, b, c) >= 0.0f) {
            return false;
        }
        float f = a.x < b.x ? (a.x < c.x ? a.x : c.x) : (minTX = b.x < c.x ? b.x : c.x);
        float f2 = a.y < b.y ? (a.y < c.y ? a.y : c.y) : (minTY = b.y < c.y ? b.y : c.y);
        float f3 = a.x > b.x ? (a.x > c.x ? a.x : c.x) : (maxTX = b.x > c.x ? b.x : c.x);
        float maxTY = a.y > b.y ? (a.y > c.y ? a.y : c.y) : (b.y > c.y ? b.y : c.y);
        float minZ = EarCut.zOrder(minTX, minTY, minX, minY, invSize);
        float maxZ = EarCut.zOrder(maxTX, maxTY, minX, minY, invSize);
        Node p = ear.prevZ;
        Node n = ear.nextZ;
        while (p != null && p.z >= minZ && n != null && n.z <= maxZ) {
            if (p != ear.prev && p != ear.next && EarCut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && EarCut.area(p.prev, p, p.next) >= 0.0f) {
                return false;
            }
            p = p.prevZ;
            if (n != ear.prev && n != ear.next && EarCut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && EarCut.area(n.prev, n, n.next) >= 0.0f) {
                return false;
            }
            n = n.nextZ;
        }
        while (p != null && p.z >= minZ) {
            if (p != ear.prev && p != ear.next && EarCut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && EarCut.area(p.prev, p, p.next) >= 0.0f) {
                return false;
            }
            p = p.prevZ;
        }
        while (n != null && n.z <= maxZ) {
            if (n != ear.prev && n != ear.next && EarCut.pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && EarCut.area(n.prev, n, n.next) >= 0.0f) {
                return false;
            }
            n = n.nextZ;
        }
        return true;
    }

    private static Node cureLocalIntersections(Node start, List<Integer> triangles, int dim) {
        Node p = start;
        do {
            Node b;
            Node a;
            if (EarCut.equals(a = p.prev, b = p.next.next) || !EarCut.intersects(a, p, p.next, b) || !EarCut.locallyInside(a, b) || !EarCut.locallyInside(b, a)) continue;
            triangles.add(a.i / dim);
            triangles.add(p.i / dim);
            triangles.add(b.i / dim);
            EarCut.removeNode(p);
            EarCut.removeNode(p.next);
            p = start = b;
        } while ((p = p.next) != start);
        return EarCut.filterPoints(p, null);
    }

    private static void splitEarcut(Node start, List<Integer> triangles, int dim, float minX, float minY, float invSize) {
        Node a = start;
        do {
            Node b = a.next.next;
            while (b != a.prev) {
                if (a.i != b.i && EarCut.isValidDiagonal(a, b)) {
                    Node c = EarCut.splitPolygon(a, b);
                    a = EarCut.filterPoints(a, a.next);
                    c = EarCut.filterPoints(c, c.next);
                    EarCut.earcutLinked(a, triangles, dim, minX, minY, invSize, 0);
                    EarCut.earcutLinked(c, triangles, dim, minX, minY, invSize, 0);
                    return;
                }
                b = b.next;
            }
        } while ((a = a.next) != start);
    }

    private static Node eliminateHoles(float[] data, int[] holeIndices, Node outerNode, int dim) {
        int i;
        ArrayList<Node> queue = new ArrayList<Node>();
        int len = holeIndices.length;
        for (i = 0; i < len; ++i) {
            int start = holeIndices[i] * dim;
            int end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
            Node list = EarCut.linkedList(data, start, end, dim, false);
            if (list == list.next) {
                list.steiner = true;
            }
            queue.add(EarCut.getLeftmost(list));
        }
        Collections.sort(queue, EarCut.compareX());
        for (i = 0; i < queue.size(); ++i) {
            EarCut.eliminateHole((Node)queue.get(i), outerNode);
            outerNode = EarCut.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static Comparator<Node> compareX() {
        return (a, b) -> Float.compare(a.x, b.x);
    }

    private static void eliminateHole(Node hole, Node outerNode) {
        if ((outerNode = EarCut.findHoleBridge(hole, outerNode)) != null) {
            Node b = EarCut.splitPolygon(outerNode, hole);
            EarCut.filterPoints(outerNode, outerNode.next);
            EarCut.filterPoints(b, b.next);
        }
    }

    private static Node findHoleBridge(Node hole, Node outerNode) {
        Node p = outerNode;
        float hx = hole.x;
        float hy = hole.y;
        float qx = -3.4028235E38f;
        Node m = null;
        do {
            float x;
            if (!(hy <= p.y) || !(hy >= p.next.y) || p.next.y == p.y || !((x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y)) <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.y) {
                    return p;
                }
                if (hy == p.next.y) {
                    return p.next;
                }
            }
            Node node = m = p.x < p.next.x ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (m == null) {
            return null;
        }
        if (hx == qx) {
            return m;
        }
        Node stop = m;
        float mx = m.x;
        float my = m.y;
        float tanMin = Float.MAX_VALUE;
        p = m;
        do {
            if (!(hx >= p.x) || !(p.x >= mx) || hx == p.x || !EarCut.pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) continue;
            float tan = Math.abs(hy - p.y) / (hx - p.x);
            if (!EarCut.locallyInside(p, hole) || !(tan < tanMin) && (tan != tanMin || !(p.x > m.x) && (p.x != m.x || !EarCut.sectorContainsSector(m, p)))) continue;
            m = p;
            tanMin = tan;
        } while ((p = p.next) != stop);
        return m;
    }

    private static boolean sectorContainsSector(Node m, Node p) {
        return EarCut.area(m.prev, m, p.prev) < 0.0f && EarCut.area(p.next, m, m.next) < 0.0f;
    }

    private static void indexCurve(Node start, float minX, float minY, float invSize) {
        Node p = start;
        do {
            if (p.z == -1.0f) {
                p.z = EarCut.zOrder(p.x, p.y, minX, minY, invSize);
            }
            p.prevZ = p.prev;
            p.nextZ = p.next;
        } while ((p = p.next) != start);
        p.prevZ.nextZ = null;
        p.prevZ = null;
        EarCut.sortLinked(p);
    }

    private static Node sortLinked(Node list) {
        int numMerges;
        int inSize = 1;
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int pSize = 0;
                for (int i = 0; i < inSize; ++i) {
                    ++pSize;
                    q = q.nextZ;
                    if (q == null) break;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e;
                    if (pSize != 0 && (qSize == 0 || q == null || p.z <= q.z)) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e;
                    } else {
                        list = e;
                    }
                    e.prevZ = tail;
                    tail = e;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
        return list;
    }

    static float zOrder(float x0, float y0, float minX, float minY, float invSize) {
        int x = (int)(32767.0f * (x0 - minX) * invSize);
        int y = (int)(32767.0f * (y0 - minY) * invSize);
        x = (x | x << 8) & 0xFF00FF;
        x = (x | x << 4) & 0xF0F0F0F;
        x = (x | x << 2) & 0x33333333;
        x = (x | x << 1) & 0x55555555;
        y = (y | y << 8) & 0xFF00FF;
        y = (y | y << 4) & 0xF0F0F0F;
        y = (y | y << 2) & 0x33333333;
        y = (y | y << 1) & 0x55555555;
        return x | y << 1;
    }

    private static Node getLeftmost(Node start) {
        Node p = start;
        Node leftmost = start;
        do {
            if (!(p.x < leftmost.x) && (p.x != leftmost.x || !(p.y < leftmost.y))) continue;
            leftmost = p;
        } while ((p = p.next) != start);
        return leftmost;
    }

    private static boolean pointInTriangle(float ax, float ay, float bx, float by, float cx, float cy, float px, float py) {
        return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0.0f && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0.0f && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0.0f;
    }

    private static boolean isValidDiagonal(Node a, Node b) {
        return a.next.i != b.i && a.prev.i != b.i && !EarCut.intersectsPolygon(a, b) && (EarCut.locallyInside(a, b) && EarCut.locallyInside(b, a) && EarCut.middleInside(a, b) && (EarCut.area(a.prev, a, b.prev) != 0.0f || EarCut.area(a, b.prev, b) != 0.0f) || EarCut.equals(a, b) && EarCut.area(a.prev, a, a.next) > 0.0f && EarCut.area(b.prev, b, b.next) > 0.0f);
    }

    private static float area(Node p, Node q, Node r) {
        return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    }

    private static boolean equals(Node p1, Node p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }

    private static boolean intersects(Node p1, Node q1, Node p2, Node q2) {
        int o1 = EarCut.sign(EarCut.area(p1, q1, p2));
        int o2 = EarCut.sign(EarCut.area(p1, q1, q2));
        int o3 = EarCut.sign(EarCut.area(p2, q2, p1));
        int o4 = EarCut.sign(EarCut.area(p2, q2, q1));
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && EarCut.onSegment(p1, p2, q1)) {
            return true;
        }
        if (o2 == 0 && EarCut.onSegment(p1, q2, q1)) {
            return true;
        }
        if (o3 == 0 && EarCut.onSegment(p2, p1, q2)) {
            return true;
        }
        return o4 == 0 && EarCut.onSegment(p2, q1, q2);
    }

    private static boolean onSegment(Node p, Node q, Node r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }

    private static int sign(float num) {
        return num > 0.0f ? 1 : (num < 0.0f ? -1 : 0);
    }

    private static boolean intersectsPolygon(Node a, Node b) {
        Node p = a;
        do {
            if (p.i == a.i || p.next.i == a.i || p.i == b.i || p.next.i == b.i || !EarCut.intersects(p, p.next, a, b)) continue;
            return true;
        } while ((p = p.next) != a);
        return false;
    }

    private static boolean locallyInside(Node a, Node b) {
        return EarCut.area(a.prev, a, a.next) < 0.0f ? EarCut.area(a, b, a.next) >= 0.0f && EarCut.area(a, a.prev, b) >= 0.0f : EarCut.area(a, b, a.prev) < 0.0f || EarCut.area(a, a.next, b) < 0.0f;
    }

    private static boolean middleInside(Node a, Node b) {
        Node p = a;
        boolean inside = false;
        float px = (a.x + b.x) / 2.0f;
        float py = (a.y + b.y) / 2.0f;
        do {
            if (p.y > py == p.next.y > py || p.next.y == p.y || !(px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)) continue;
            boolean bl = inside = !inside;
        } while ((p = p.next) != a);
        return inside;
    }

    private static Node splitPolygon(Node a, Node b) {
        Node a2 = new Node(a.i, a.x, a.y);
        Node b2 = new Node(b.i, b.x, b.y);
        Node an = a.next;
        Node bp = b.prev;
        a.next = b;
        b.prev = a;
        a2.next = an;
        an.prev = a2;
        b2.next = a2;
        a2.prev = b2;
        bp.next = b2;
        b2.prev = bp;
        return b2;
    }

    private static Node insertNode(int i, float x, float y, Node last) {
        Node p = new Node(i, x, y);
        if (last == null) {
            p.prev = p;
            p.next = p;
        } else {
            p.next = last.next;
            p.prev = last;
            last.next.prev = p;
            last.next = p;
        }
        return p;
    }

    private static void removeNode(Node p) {
        p.next.prev = p.prev;
        p.prev.next = p.next;
        if (p.prevZ != null) {
            p.prevZ.nextZ = p.nextZ;
        }
        if (p.nextZ != null) {
            p.nextZ.prevZ = p.prevZ;
        }
    }

    public float deviation(float[] data, int[] holeIndices, int dim, List<Integer> triangles) {
        boolean hasHoles = holeIndices != null && holeIndices.length > 0;
        int outerLen = hasHoles ? holeIndices[0] * dim : data.length;
        float polygonArea = Math.abs(EarCut.signedArea(data, 0, outerLen, dim));
        if (hasHoles) {
            int len = holeIndices.length;
            for (int i = 0; i < len; ++i) {
                int start = holeIndices[i] * dim;
                int end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
                polygonArea -= Math.abs(EarCut.signedArea(data, start, end, dim));
            }
        }
        float trianglesArea = 0.0f;
        for (int i = 0; i < triangles.size(); i += 3) {
            int a = triangles.get(i) * dim;
            int b = triangles.get(i + 1) * dim;
            int c = triangles.get(i + 2) * dim;
            trianglesArea += Math.abs((data[a] - data[c]) * (data[b + 1] - data[a + 1]) - (data[a] - data[b]) * (data[c + 1] - data[a + 1]));
        }
        return polygonArea == 0.0f && trianglesArea == 0.0f ? 0.0f : Math.abs((trianglesArea - polygonArea) / polygonArea);
    }

    private static float signedArea(float[] data, int start, int end, int dim) {
        float sum = 0.0f;
        int j = end - dim;
        for (int i = start; i < end; i += dim) {
            sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
            j = i;
        }
        return sum;
    }

    public static Object[] flatten(float[][][] data) {
        int dim = data[0][0].length;
        Object[] result = new Object[]{new ArrayList(), new ArrayList(), dim};
        int holeIndex = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                for (int d = 0; d < dim; ++d) {
                    ((List)result[0]).add(Float.valueOf(data[i][j][d]));
                }
            }
            if (i <= 0) continue;
            ((List)result[1]).add(holeIndex += data[i - 1].length);
        }
        return result;
    }

    static class Node {
        int i;
        float x;
        float y;
        float z;
        boolean steiner;
        Node prev;
        Node next;
        Node nextZ;
        Node prevZ;

        Node(int i, float x, float y) {
            this.i = i;
            this.x = x;
            this.y = y;
            this.prev = null;
            this.next = null;
            this.z = -1.0f;
            this.prevZ = null;
            this.nextZ = null;
            this.steiner = false;
        }
    }
}

