/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.triangulate;

import eu.javaexperience.calcad.lib.ModelObjectTools;
import eu.javaexperience.calcad.lib.triangulate.EarCut;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.Polygon;
import eu.mihosoft.jcsg.Vertex;
import eu.mihosoft.vvecmath.ModifiableVector3d;
import eu.mihosoft.vvecmath.Transform;
import eu.mihosoft.vvecmath.Vector3d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReusablePolygonTriangulator {
    protected List<Polygon> dst = new ArrayList<Polygon>();
    protected List<Integer> triangles = new ArrayList<Integer>();
    protected float[] d2points = new float[16];
    protected int d2ep = 0;

    public static double angleX(Vector3d v) {
        return 57.29577951308232 * Math.acos(v.y() / v.magnitude());
    }

    public static double angleY(Vector3d v) {
        return 57.29577951308232 * Math.acos(v.x() / v.magnitude());
    }

    public List<Polygon> triangulate(Vector3d normal, Polygon poly) {
        this.dst.clear();
        if (poly.vertices.size() < 4) {
            this.dst.add(poly);
            return this.dst;
        }
        this.d2ep = 0;
        this.triangles.clear();
        Transform rot = new Transform().rot(normal, Vector3d.Z_ONE);
        for (Vertex v : poly.vertices) {
            ModifiableVector3d pos = v.pos.asModifiable();
            pos = rot.transform(pos);
            if (this.d2points.length + 2 < this.d2ep) {
                this.d2points = Arrays.copyOf(this.d2points, this.d2points.length * 2);
            }
            this.d2points[this.d2ep++] = (float)pos.x();
            this.d2points[this.d2ep++] = (float)pos.y();
        }
        EarCut.earcut(this.triangles, this.d2points, this.d2ep, null, 2);
        for (int i = 0; i < this.triangles.size(); i += 3) {
            this.dst.add(new Polygon(new Vertex[]{(Vertex)poly.vertices.get(this.triangles.get(i)), (Vertex)poly.vertices.get(this.triangles.get(i + 1)), (Vertex)poly.vertices.get(this.triangles.get(i + 2))}));
        }
        return this.dst;
    }

    public void reuse() {
    }

    public static Polygon createPolygon(double normalX, double normalY, double normalZ, double ... coords3d) {
        Vector3d normal = Vector3d.xyz((double)normalX, (double)normalY, (double)normalZ);
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        for (int i = 0; i < coords3d.length; i += 3) {
            vs.add(new Vertex(Vector3d.xyz((double)coords3d[i], (double)coords3d[i + 1], (double)coords3d[i + 2]), normal));
        }
        return new Polygon(vs);
    }

    public static void addPoly(Polygon poly, List<ModelObjectTools.Triangle> tris, ReusablePolygonTriangulator tri) {
        Vector3d normal = ((Vertex)poly.vertices.get((int)0)).normal;
        tri.reuse();
        for (Polygon t : tri.triangulate(normal, poly)) {
            if (3 != t.vertices.size()) {
                System.out.println("invalid");
            }
            tris.add(new ModelObjectTools.Triangle(normal, ((Vertex)t.vertices.get((int)0)).pos, ((Vertex)t.vertices.get((int)1)).pos, ((Vertex)t.vertices.get((int)2)).pos));
        }
    }

    public static List<ModelObjectTools.Triangle> toTriangles(CSG object) {
        List polys = object.getPolygons();
        ArrayList<ModelObjectTools.Triangle> tris = new ArrayList<ModelObjectTools.Triangle>();
        ReusablePolygonTriangulator tri = new ReusablePolygonTriangulator();
        for (Polygon poly : polys) {
            ReusablePolygonTriangulator.addPoly(poly, tris, tri);
        }
        return tris;
    }
}

