/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.examples.metrix;

import eu.javaexperience.calcad.lib.Cal;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.vvecmath.Transform;
import java.util.ArrayList;
import java.util.List;

public class MetrixBlockBuilder {
    public int block_x = 1;
    public int block_y = 1;
    public int block_z = 1;
    public double drill_dia = 4.1;
    public boolean drill_x = true;
    public boolean drill_y = true;
    public boolean drill_z = true;
    public boolean relieve = true;
    public double relieve_dia = 2.0;

    protected CSG drill_hole(double h) {
        return Cal.cylinder(this.drill_dia / 2.0, h);
    }

    protected CSG relieve_hole(double h) {
        return Cal.cylinder(this.relieve_dia / 2.0, h);
    }

    protected void relieve_holes(List<CSG> subs, Transform rotate, double x0, double y0, double z0, double h, boolean fl_x, boolean fl_y) {
        double relieve_offset = 2.5 + this.relieve_dia / 4.0;
        subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0 + relieve_offset, y0 + relieve_offset, z0))));
        subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0 + relieve_offset, y0 - relieve_offset, z0))));
        subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0 - relieve_offset, y0 + relieve_offset, z0))));
        subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0 - relieve_offset, y0 - relieve_offset, z0))));
        if (fl_x) {
            subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0 + 5.0, y0, z0))));
        }
        if (fl_y) {
            subs.add(this.relieve_hole(h).transformed(Cal.combine(rotate, Cal.move(x0, y0 + 5.0, z0))));
        }
    }

    protected static boolean first_last(int i, int max) {
        return 0 < i && i < max;
    }

    protected void machining(List<CSG> subs, Transform rotate, double x0, double y0, double z0, double drill, boolean fl_x, boolean fl_y) {
        subs.add(this.drill_hole(drill).transformed(Cal.combine(rotate, Cal.move(x0, y0, z0))));
        if (this.relieve) {
            this.relieve_holes(subs, rotate, x0, y0, z0, drill, fl_x, fl_y);
        }
    }

    public CSG generateBlock() {
        int x;
        int z;
        ArrayList<CSG> subs;
        boolean debug_drills = false;
        CSG base = Cal.cube(this.block_x * 10, this.block_y * 10, this.block_z * 10);
        if (this.drill_x) {
            subs = new ArrayList<CSG>();
            Transform rotx = Cal.rotate(-90.0, -90.0, 0.0);
            for (int y = 1; y <= this.block_y; ++y) {
                for (z = 1; z <= this.block_z; ++z) {
                    this.machining(subs, rotx, -5.0 + (double)(y * 10), -5.0 + (double)(z * 10), -0.5, 1 + this.block_x * 10, MetrixBlockBuilder.first_last(y, this.block_y), MetrixBlockBuilder.first_last(z, this.block_z));
                }
            }
            CSG cSG = base = debug_drills ? Cal.union(base, Cal.union(subs)) : base.difference(Cal.union(subs));
        }
        if (this.drill_y) {
            subs = new ArrayList();
            Transform roty = Cal.rotate(-90.0, 0.0, 0.0);
            for (x = 1; x <= this.block_x; ++x) {
                for (z = 1; z <= this.block_z; ++z) {
                    this.machining(subs, roty, -5 + x * 10, -5 + z * 10, -0.5 - (double)(this.block_y * 10), 1 + this.block_y * 10, MetrixBlockBuilder.first_last(x, this.block_x), MetrixBlockBuilder.first_last(z, this.block_z));
                }
            }
            CSG cSG = base = debug_drills ? Cal.union(base, Cal.union(subs)) : base.difference(Cal.union(subs));
        }
        if (this.drill_z) {
            subs = new ArrayList();
            Transform rotz = Cal.rotate(0.0, 0.0, 0.0);
            for (x = 1; x <= this.block_x; ++x) {
                for (int y = 1; y <= this.block_y; ++y) {
                    this.machining(subs, rotz, -5 + x * 10, -5 + y * 10, -0.5, 1 + this.block_z * 10, MetrixBlockBuilder.first_last(x, this.block_x), MetrixBlockBuilder.first_last(y, this.block_y));
                }
            }
            base = debug_drills ? Cal.union(base, Cal.union(subs)) : base.difference(Cal.union(subs));
        }
        return base;
    }
}

