/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.calcad.lib.AxisBoundingBox;
import eu.javaexperience.calcad.lib.ModelObjectTools;
import eu.javaexperience.calcad.lib.parallel.ParallelTask;
import eu.javaexperience.calcad.lib.preview.CalCadInspector;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.multithread.TaskExecutorPool;
import eu.javaexperience.reflect.Mirror;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.Cube;
import eu.mihosoft.jcsg.Cylinder;
import eu.mihosoft.jcsg.Polygon;
import eu.mihosoft.jcsg.STL;
import eu.mihosoft.jcsg.Sphere;
import eu.mihosoft.jcsg.Vertex;
import eu.mihosoft.vvecmath.Transform;
import eu.mihosoft.vvecmath.Vector3d;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;

public class Cal {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("Cal"));
    public static int FACETS = 32;
    public static final CSG CSG_EMPTY = CSG.fromPolygons((List)new NullList());
    protected static TaskExecutorPool THREAD_POOL = new TaskExecutorPool(){

        public synchronized void execute(Runnable exec) {
            int th = this.getThreadsCount();
            super.execute(exec);
            int now = this.getThreadsCount();
            if (th != now) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"Running threads: %s", (Object)now);
            }
        }
    };
    protected static int PARALLELISM = Runtime.getRuntime().availableProcessors() - 1;
    protected static Semaphore PARALLEL_CALC_SEMAPHORE = new Semaphore(PARALLELISM);

    public static void setParallelism(int parallel) {
        AssertArgument.assertGreaterOrEqualsThan((int)parallel, (int)1, (String)"parallelism");
        final int diff = PARALLELISM - parallel;
        if (diff > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        PARALLEL_CALC_SEMAPHORE.acquire(diff);
                    }
                    catch (InterruptedException e) {
                        Mirror.propagateAnyway((Throwable)e);
                    }
                }
            }.start();
        } else {
            PARALLEL_CALC_SEMAPHORE.release(-diff);
        }
        PARALLELISM = parallel;
    }

    public static int getParallelism() {
        return PARALLELISM;
    }

    public static boolean addVertexUnique(Collection<Vertex> dst, Vertex v) {
        for (Vertex dv : dst) {
            if (!Cal.equals(dv.pos, v.pos)) continue;
            return false;
        }
        dst.add(v);
        return true;
    }

    public static boolean contains(List<Vertex> vxs, Vertex vx) {
        for (Vertex v : vxs) {
            if (!Cal.equals(vx.pos, v.pos)) continue;
            return true;
        }
        return false;
    }

    public static CSG cube(double x, double y, double z) {
        return CSG.fromPolygons((List)new Cube(x, y, z).noCenter().toPolygons());
    }

    public static CSG cube(double size) {
        return CSG.fromPolygons((List)new Cube(size).noCenter().toPolygons());
    }

    public static CSG sphere(double size, int faces) {
        return CSG.fromPolygons((List)new Sphere(size, faces, faces).toPolygons());
    }

    public static CSG sphere(double size) {
        return Cal.sphere(size, FACETS);
    }

    public static CSG cylinder(double radius, double height, int faces) {
        return CSG.fromPolygons((List)new Cylinder(radius, height, faces).toPolygons());
    }

    public static CSG cylinder(double radius, double height) {
        return Cal.cylinder(radius, height, FACETS);
    }

    public static Polygon polygonZ(double ... xy) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        for (int i = 0; i < xy.length; i += 2) {
            vs.add(new Vertex(Vector3d.xyz((double)xy[i], (double)xy[i + 1], (double)0.0), Vector3d.Z_ONE));
        }
        return new Polygon(vs);
    }

    public static Transform move(double x, double y, double z) {
        return new Transform().translate(x, y, z);
    }

    public static Transform rotate(double degX, double degY, double degZ) {
        return new Transform().rot(degX, degY, degZ);
    }

    public static Transform scale(double scale) {
        return new Transform().scale(scale);
    }

    public static Transform scale(double sX, double sY, double sZ) {
        return new Transform().scale(sX, sY, sZ);
    }

    public static Transform combine(Transform ... transforms) {
        Transform t = new Transform();
        for (Transform tr : transforms) {
            if (null == tr) continue;
            t.apply(tr);
        }
        return t;
    }

    public static CSG transform(CSG csg, Transform ... transforms) {
        return csg.transformed(Cal.combine(transforms));
    }

    protected static CSG tryGetFirstOrMakeEmpty(CSG[] arr) {
        if (null == arr || 0 == arr.length || null == arr[0]) {
            return CSG.fromPolygons((List)NullList.instance);
        }
        return arr[0];
    }

    protected static CSG tryGetFirstOrMakeEmpty(List<CSG> arr) {
        if (null == arr || 0 == arr.size() || null == arr.get(0)) {
            return CSG.fromPolygons((List)NullList.instance);
        }
        return arr.get(0);
    }

    protected static <T> List<T>[] twoHalf(List<T> list) {
        int i;
        List[] ret = new List[]{new ArrayList(), new ArrayList()};
        for (i = 0; i < list.size() / 2; ++i) {
            ret[0].add(list.get(i));
        }
        for (i = list.size() / 2; i < list.size(); ++i) {
            ret[1].add(list.get(i));
        }
        return ret;
    }

    protected static List<CSG> from(List<CSG> source, int from) {
        ArrayList<CSG> ret = new ArrayList<CSG>();
        for (int i = from; i < source.size(); ++i) {
            ret.add(source.get(i));
        }
        return ret;
    }

    protected static ParallelTask postCalculateUnion(final List<CSG> obj) {
        ParallelTask ret = new ParallelTask(obj){

            @Override
            protected CSG doCsgOperation(List<CSG> inputs) {
                return Cal.runUnionParallel(obj);
            }
        };
        THREAD_POOL.execute((Runnable)ret);
        return ret;
    }

    protected static CSG runUnionParallel(List<CSG> objs) {
        switch (objs.size()) {
            case 0: {
                return CSG.fromPolygons((List)NullList.instance);
            }
            case 1: {
                return objs.get(0);
            }
            case 2: {
                try {
                    PARALLEL_CALC_SEMAPHORE.acquire();
                    CSG cSG = objs.get(0).union(objs.get(1));
                    return cSG;
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                finally {
                    PARALLEL_CALC_SEMAPHORE.release();
                }
                return null;
            }
        }
        List<CSG>[] hs = Cal.twoHalf(objs);
        ParallelTask a = Cal.postCalculateUnion(hs[0]);
        ParallelTask b = Cal.postCalculateUnion(hs[1]);
        return Cal.runUnionParallel(CollectionTools.inlineArrayList((Object[])new CSG[]{a.getDoneResult(), b.getDoneResult()}));
    }

    public static CSG union(CSG ... objects) {
        return Cal.union(CollectionTools.inlineArrayList((Object[])objects));
    }

    public static CSG union(List<CSG> objects) {
        long t0 = System.currentTimeMillis();
        CSG ret = Cal.runUnionParallel(objects);
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"union of objects %s took %s ms", objects, (Object)(System.currentTimeMillis() - t0));
        return ret;
    }

    public static CSG difference(CSG ... objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.difference(Cal.union(Arrays.copyOfRange(objects, 1, objects.length)));
        return ret;
    }

    public static CSG difference(List<CSG> objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.difference(Cal.from(objects, 1));
        return ret;
    }

    public static CSG intersection(CSG ... objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.intersect(Arrays.copyOfRange(objects, 1, objects.length));
        return ret;
    }

    public static CSG intersection(List<CSG> objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.intersect(Cal.from(objects, 1));
        return ret;
    }

    public static CSG hull(CSG ... objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.hull(Arrays.copyOfRange(objects, 1, objects.length));
        return ret;
    }

    public static CSG hull(List<CSG> objects) {
        CSG ret = Cal.tryGetFirstOrMakeEmpty(objects);
        ret = ret.hull(Cal.from(objects, 1));
        return ret;
    }

    public static AxisBoundingBox getBoundBox(CSG obj) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (Polygon p : obj.getPolygons()) {
            for (Vertex v : p.vertices) {
                if (minX > v.pos.x()) {
                    minX = v.pos.x();
                }
                if (minY > v.pos.y()) {
                    minY = v.pos.y();
                }
                if (minZ > v.pos.z()) {
                    minZ = v.pos.z();
                }
                if (maxX < v.pos.x()) {
                    maxX = v.pos.x();
                }
                if (maxY < v.pos.y()) {
                    maxY = v.pos.y();
                }
                if (!(maxZ < v.pos.z())) continue;
                maxZ = v.pos.z();
            }
        }
        return new AxisBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static boolean equals(Vector3d a, Vector3d b) {
        return a.x() == b.x() && a.y() == b.y() && a.z() == b.z();
    }

    public static void showInNewInspectionWindow(CSG obj) {
        CalCadInspector.openNewWindow("CalCAD - Object inspector", 1024, 768, obj);
    }

    public static CSG loadStl(String file) {
        try {
            return STL.file((Path)new File(file).toPath());
        }
        catch (IOException e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static void writeStl(CSG obj, String file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            ModelObjectTools.writeStlData(fos, obj);
            fos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            Mirror.propagateAnyway((Throwable)e);
        }
    }
}

