/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib;

import eu.javaexperience.calcad.lib.Cal;
import eu.javaexperience.reflect.Mirror;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.STL;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CalGui {
    public static File promptFile(String title, boolean save_open, String typeName, String extension) {
        return CalGui.promptFile(title, save_open, null == typeName || null == extension ? null : new FileNameExtensionFilter(typeName, extension));
    }

    public static File promptFile(String title, boolean save_open, FileNameExtensionFilter filter) {
        int userSelection;
        JFrame parentFrame = new JFrame();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        if (null != filter) {
            chooser.setFileFilter(filter);
        }
        int n = userSelection = save_open ? chooser.showSaveDialog(parentFrame) : chooser.showOpenDialog(parentFrame);
        if (userSelection == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static CSG promptOpenStlFile() {
        try {
            File f = CalGui.promptFile("Opening STL file", true, new FileNameExtensionFilter("STL file", "stl"));
            if (null != f) {
                return STL.file((Path)f.toPath());
            }
            return null;
        }
        catch (Exception e) {
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    public static boolean promptSaveStlFile(CSG obj) {
        File f = CalGui.promptFile("Specify STL file to save", true, new FileNameExtensionFilter("STL file", "stl"));
        if (null != f) {
            Cal.writeStl(obj, f.toString());
            return true;
        }
        return false;
    }
}

