/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.document.DocumentTools;
import eu.javaexperience.functional.BoolFunctions;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import eu.mihosoft.jcsg.Polygon;
import eu.mihosoft.jcsg.Vertex;
import eu.mihosoft.vvecmath.Vector3d;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CalSvg {
    protected static Map<String, String> PATH_SVG_OBJECTS = new SmallMap();

    public static Document readXml(String file) {
        Document document;
        FileInputStream fis = new FileInputStream(file);
        try {
            document = DocumentTools.parseDocument((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        }
        fis.close();
        return document;
    }

    public static Polygon importSvgPolygon(String file, @MayNull String id) {
        GetBy1 sel = null;
        if (null != id) {
            sel = DocumentTools.selectNodesByAttributeValue((String)"id", (String)id);
        }
        return CalSvg.importSvgWithProbes(file, (GetBy1<Boolean, Node>)sel, PATH_SVG_OBJECTS);
    }

    public static Polygon importSvgWithProbes(String file, GetBy1<Boolean, Node> sel, Map<String, String> node_attrs) {
        Document doc = CalSvg.readXml(file);
        for (Map.Entry<String, String> kv : node_attrs.entrySet()) {
            Node el;
            GetBy1 s = DocumentTools.selectNodesByTagName((String)kv.getKey());
            if (null != sel) {
                s = BoolFunctions.and((GetBy1[])new GetBy1[]{s, sel});
            }
            if (null == (el = DocumentTools.findFirst((Node)doc, (GetBy1)s))) continue;
            Node ps = DocumentTools.getAttr((Node)el, (String)kv.getValue());
            return CalSvg.parsePolygon(ps.getNodeValue());
        }
        throw new RuntimeException("Polygon not found");
    }

    public static Polygon importSvgPath(String file, String id) {
        Node el;
        Document doc = CalSvg.readXml(file);
        GetBy1 s = DocumentTools.selectNodesByTagName((String)"path");
        GetBy1 sel = null;
        if (null != id) {
            sel = BoolFunctions.and((GetBy1[])new GetBy1[]{sel, DocumentTools.selectNodesByAttributeValue((String)"id", (String)id)});
        }
        if (null != (el = DocumentTools.findFirst((Node)doc, (GetBy1)s))) {
            Node ps = DocumentTools.getAttr((Node)el, (String)"d");
            String[] els = ps.getNodeValue().split("\\s+");
            double x = 0.0;
            double y = 0.0;
            ArrayList<Vertex> vs = new ArrayList<Vertex>();
            block24: for (int i = 0; i < els.length; ++i) {
                boolean hv = false;
                switch (els[i]) {
                    case "c": 
                    case "C": {
                        ++i;
                    }
                    case "s": 
                    case "S": {
                        ++i;
                    }
                    case "m": 
                    case "M": 
                    case "l": 
                    case "L": {
                        ++i;
                    }
                    default: {
                        String[] cc = els[i].split(",");
                        vs.add(new Vertex(Vector3d.xyz((double)(x += Double.parseDouble(cc[0])), (double)(y += Double.parseDouble(cc[1])), (double)0.0), Vector3d.Z_ONE));
                        continue block24;
                    }
                    case "h": 
                    case "H": {
                        hv = true;
                    }
                    case "v": 
                    case "V": {
                        double d = Double.parseDouble(els[++i]);
                        if (hv) {
                            x += d;
                        } else {
                            y += d;
                        }
                        vs.add(new Vertex(Vector3d.xyz((double)x, (double)y, (double)0.0), Vector3d.Z_ONE));
                        continue block24;
                    }
                    case "z": 
                    case "Z": {
                        ++i;
                    }
                }
            }
            return new Polygon(vs);
        }
        throw new RuntimeException("Polygon not found");
    }

    public static Polygon parsePolygon(String poly) {
        ArrayList<Vertex> vs = new ArrayList<Vertex>();
        poly = poly.trim();
        for (String p : poly.split("\\s+")) {
            String[] cc = p.split(",");
            if (2 != cc.length) continue;
            vs.add(new Vertex(Vector3d.xyz((double)Double.parseDouble(cc[0]), (double)Double.parseDouble(cc[1]), (double)0.0), Vector3d.Z_ONE));
        }
        return new Polygon(vs);
    }

    static {
        PATH_SVG_OBJECTS.put("polygon", "points");
    }
}

