/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib;

import eu.javaexperience.collection.list.NullList;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.Polygon;
import eu.mihosoft.jcsg.Vertex;
import eu.mihosoft.vvecmath.Transform;
import eu.mihosoft.vvecmath.Vector3d;
import java.util.ArrayList;
import java.util.List;

public class Extruder {
    protected List<Polygon> segments = new ArrayList<Polygon>();
    protected Polygon current;

    public Extruder(Polygon p) {
        this.current = p.flip();
        this.segments.add(this.current);
    }

    protected static Polygon createValidPolygon(int minPoints, Vertex ... vx) {
        return new Polygon(vx);
    }

    protected static boolean addValidPolygon(List<Polygon> segments, int minPoints, Vertex ... vxs) {
        Polygon ps = Extruder.createValidPolygon(minPoints, vxs);
        if (null != ps) {
            segments.add(ps);
        }
        return null != ps;
    }

    public void step(Transform transform) {
        Polygon next = this.current.clone().transform(transform);
        List cv = this.current.vertices;
        List nv = next.vertices;
        for (int i = 0; i < cv.size() - 1; ++i) {
            Extruder.addValidPolygon(this.segments, 4, new Vertex(((Vertex)nv.get((int)i)).pos, Vector3d.Z_ONE), new Vertex(((Vertex)nv.get((int)(i + 1))).pos, Vector3d.Z_ONE), new Vertex(((Vertex)cv.get((int)(i + 1))).pos, Vector3d.Z_ONE), new Vertex(((Vertex)cv.get((int)i)).pos, Vector3d.Z_ONE));
        }
        Extruder.addValidPolygon(this.segments, 4, new Vertex(((Vertex)nv.get((int)(cv.size() - 1))).pos, Vector3d.Z_ONE), new Vertex(((Vertex)nv.get((int)0)).pos, Vector3d.Z_ONE), new Vertex(((Vertex)cv.get((int)0)).pos, Vector3d.Z_ONE), new Vertex(((Vertex)cv.get((int)(cv.size() - 1))).pos, Vector3d.Z_ONE));
        this.current = next;
    }

    public CSG end() {
        if (this.segments.isEmpty()) {
            return CSG.fromPolygons((List)NullList.instance);
        }
        this.segments.add(this.current.flip());
        return CSG.fromPolygons(this.segments);
    }

    public static Extruder toExtrudeDirection(Polygon shape, Vector3d dir) {
        if (((Vertex)shape.vertices.get((int)0)).normal.dot(dir) < 0.0) {
            return new Extruder(shape.flip());
        }
        return new Extruder(shape);
    }
}

