/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib;

import eu.javaexperience.calcad.lib.triangulate.ReusablePolygonTriangulator;
import eu.javaexperience.io.BufferedOutput;
import eu.javaexperience.text.StringTools;
import eu.mihosoft.jcsg.CSG;
import eu.mihosoft.jcsg.Polygon;
import eu.mihosoft.jcsg.Vertex;
import eu.mihosoft.vvecmath.Vector3d;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ModelObjectTools {
    protected static void writeFloat(OutputStream dos, float value) throws IOException {
        int v = Float.floatToRawIntBits(value);
        dos.write(v & 0xFF);
        dos.write(v >> 8 & 0xFF);
        dos.write(v >> 16 & 0xFF);
        dos.write(v >> 24 & 0xFF);
    }

    protected static void writeVector(OutputStream dos, Vector3d vec) throws IOException {
        ModelObjectTools.writeFloat(dos, (float)vec.getX());
        ModelObjectTools.writeFloat(dos, (float)vec.getY());
        ModelObjectTools.writeFloat(dos, (float)vec.getZ());
    }

    public static List<Triangle> toTriangles(CSG object) {
        List polys = object.getPolygons();
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (Polygon poly : polys) {
            ModelObjectTools.addPoly(poly, tris);
        }
        return tris;
    }

    public static void addPoly(Polygon poly, List<Triangle> tris) {
        for (int i = 0; i < poly.vertices.size() - 2; ++i) {
            tris.add(new Triangle(((Vertex)poly.vertices.get((int)0)).normal, ((Vertex)poly.vertices.get((int)0)).pos, ((Vertex)poly.vertices.get((int)(i + 1))).pos, ((Vertex)poly.vertices.get((int)(i + 2))).pos));
        }
    }

    public static void writeStlData(OutputStream out, CSG object) throws IOException {
        BufferedOutput os = new BufferedOutput(out);
        String header = "CalCAD exported 3d Object";
        header = header + StringTools.repeatChar((char)' ', (int)(80 - header.length()));
        os.write(header.getBytes());
        List<Triangle> tris = ReusablePolygonTriangulator.toTriangles(object);
        int v = tris.size();
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 24 & 0xFF);
        for (Triangle t : tris) {
            t.write((OutputStream)os);
        }
        os.flush();
    }

    public static class Triangle {
        public Vector3d normal;
        public Vector3d x;
        public Vector3d y;
        public Vector3d z;

        public Triangle(Vector3d normal, Vector3d x, Vector3d y, Vector3d z) {
            this.normal = normal;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void write(OutputStream dos) throws IOException {
            ModelObjectTools.writeVector(dos, this.normal);
            ModelObjectTools.writeVector(dos, this.x);
            ModelObjectTools.writeVector(dos, this.y);
            ModelObjectTools.writeVector(dos, this.z);
            dos.write(0);
            dos.write(0);
        }
    }
}

