/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.port;

import eu.javaexperience.calcad.lib.Cal;
import eu.javaexperience.calcad.lib.port.AbstractPortShape;
import eu.javaexperience.calcad.lib.surface.SurfaceAlignment;
import eu.mihosoft.jcsg.CSG;

public class CirclePortShape
extends AbstractPortShape {
    public double r;

    public CirclePortShape(SurfaceAlignment align, double x, double y, double r) {
        super(align, x, y);
        this.r = r;
    }

    @Override
    public CSG generate(double thickness) {
        double[] off = this.align.translateFrom(SurfaceAlignment.CENTERED, 2.0 * this.r, 2.0 * this.r);
        return Cal.cylinder(this.r, thickness).transformed(Cal.move(this.x + off[0], this.y + off[1], -thickness / 2.0));
    }

    @Override
    public double[] getShapeSize() {
        return new double[]{this.r * 2.0, this.r * 2.0};
    }

    @Override
    public CSG generateBase(double thickness) {
        return Cal.cylinder(this.r, thickness);
    }
}

