/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.preview;

import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.swing.JComponent;

public class CalCadInspectionNavigator
implements EventHandler<javafx.scene.input.MouseEvent>,
KeyListener,
MouseWheelListener,
MouseListener,
MouseMotionListener {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("CalCadInspectionNavigator"));
    protected double anchorX;
    protected double anchorY;
    protected Rotate rotateX = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
    protected Rotate rotateZ = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Z_AXIS);
    protected Translate translate = new Translate();
    protected Scale scale = new Scale();
    public MouseButton move;
    public MouseButton rotate;
    public double rotateSpeed = 0.7;
    public double moveSpeed = 0.7;
    public double zoomSpeed = 0.1;
    protected Node controlledNode;
    protected EventMediator<KeyEvent> keyTyped = new EventMediator();
    protected int button = -1;

    public CalCadInspectionNavigator(Node n, MouseButton move, MouseButton rotate) {
        this.controlledNode = n;
        this.controlledNode.getTransforms().addAll((Object[])new Transform[]{this.translate, this.scale, this.rotateX, this.rotateZ});
        this.move = move;
        this.rotate = rotate;
    }

    protected void accumulateAnchor(double x, double y) {
        this.anchorX = x;
        this.anchorY = y;
    }

    protected void applyRotateDiff(double x, double y) {
        this.rotateZ.setAngle(this.rotateZ.getAngle() - (this.anchorX - x) * this.rotateSpeed);
        this.rotateX.setAngle(this.rotateX.getAngle() - (this.anchorY - y) * this.rotateSpeed);
    }

    protected void applyMoveDiff(double x, double y) {
        this.translate.setX(this.translate.getX() - (this.anchorX - x) * this.moveSpeed);
        this.translate.setY(this.translate.getY() - (this.anchorY - y) * this.moveSpeed);
    }

    protected void applyZoomDiff(double diff) {
        this.setScale(this.scale.getX() - diff);
    }

    public void handle(javafx.scene.input.MouseEvent t) {
        if (this.move.equals((Object)t.getButton())) {
            boolean accAnchor = javafx.scene.input.MouseEvent.MOUSE_PRESSED.equals(t.getEventType());
            if (javafx.scene.input.MouseEvent.MOUSE_DRAGGED.equals(t.getEventType())) {
                this.applyMoveDiff(t.getSceneX(), t.getSceneY());
                accAnchor = true;
            }
            if (accAnchor) {
                this.accumulateAnchor(t.getSceneX(), t.getSceneY());
                t.consume();
            }
        } else if (this.rotate.equals((Object)t.getButton())) {
            boolean accAnchor = javafx.scene.input.MouseEvent.MOUSE_PRESSED.equals(t.getEventType());
            if (javafx.scene.input.MouseEvent.MOUSE_DRAGGED.equals(t.getEventType())) {
                this.applyRotateDiff(t.getSceneX(), t.getSceneY());
                accAnchor = true;
            }
            if (accAnchor) {
                this.accumulateAnchor(t.getSceneX(), t.getSceneY());
                t.consume();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"keyTyped: %s", (Object)arg0);
        this.keyTyped.dispatchEvent((Object)arg0);
    }

    public void setScale(double scale) {
        if (scale > 0.0) {
            this.scale.setX(scale);
            this.scale.setY(scale);
            this.scale.setZ(scale);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        this.applyZoomDiff(arg0.getPreciseWheelRotation() * this.zoomSpeed);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.button = arg0.getButton();
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"mouse pressed: %s", (Object)this.button);
        this.accumulateAnchor(arg0.getX(), arg0.getY());
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.DEBUG, (String)"mouse released: %s", (Object)this.button);
        this.button = -1;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (this.move.ordinal() == this.button) {
            this.applyMoveDiff(arg0.getX(), arg0.getY());
        } else if (this.rotate.ordinal() == this.button) {
            this.applyRotateDiff(arg0.getX(), arg0.getY());
        }
        this.accumulateAnchor(arg0.getX(), arg0.getY());
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    public void installListeners(JComponent comp) {
        comp.addKeyListener(this);
        comp.addMouseWheelListener(this);
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
    }

    public Node getControllerNode() {
        return this.controlledNode;
    }

    public EventMediator<KeyEvent> getKeyTypeMediator() {
        return this.keyTyped;
    }
}

