/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.calcad.lib.preview;

import eu.javaexperience.calcad.lib.CalGui;
import eu.javaexperience.calcad.lib.preview.CalCadInspector;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.mihosoft.jcsg.CSG;
import javax.swing.JButton;

public class HcrPrototyper {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("HcrPrototyper"));
    protected CalCadInspector inspector = new CalCadInspector();
    protected SimpleGet<CSG> generator;
    protected JButton btnRefresh = new JButton("Refresh");
    protected JButton btnSave = new JButton("Save STL");

    public HcrPrototyper(SimpleGet<CSG> generator) {
        this.generator = generator;
        this.inspector.frame.setTitle("CalCAD - HCR Prototyper inspector");
        this.inspector.getBottomPanel().add(this.btnRefresh);
        this.inspector.getBottomPanel().add(this.btnSave);
        this.btnRefresh.addActionListener(e -> this.regenerateAndInspect());
        this.btnSave.addActionListener(e -> this.promptSaveCurrentModel());
        CalCadInspector.addViewHotkeys(this.inspector);
    }

    protected void promptSaveCurrentModel() {
        CalGui.promptSaveStlFile(this.inspector.getShownObject());
    }

    public void regenerateAndInspect() {
        long t0 = System.currentTimeMillis();
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Calling regenerateAndInspect", (Object[])new Object[0]);
        this.inspector.show((CSG)this.generator.get());
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.MEASURE, (String)"Calling regenerateAndInspect took: %s ms", (Object)(System.currentTimeMillis() - t0));
    }

    public void showWindow() {
        this.inspector.setInspectorVisible(true);
        this.btnRefresh.doClick();
        this.inspector.viewIsometric();
    }

    public CalCadInspector getInspector() {
        return this.inspector;
    }
}

