/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.algorithm.search.graph;

import eu.javaexperience.algorithm.search.graph.GraphSearchAlgorithm;
import eu.javaexperience.algorithm.search.graph.GraphSearchExtendAlgorithm;
import eu.javaexperience.algorithm.search.graph.GraphSearchTraveledPath;
import eu.javaexperience.algorithm.search.graph.GraphSearcher;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.BulkTransitMap;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphSearchAlgorithms {
    protected static final Comparator<Map.Entry<GraphSearchTraveledPath<?, ?>, ?>> ORDER_BY_GRAPH_PATH_LENGTH = new Comparator<Map.Entry<GraphSearchTraveledPath<?, ?>, ?>>(){

        @Override
        public int compare(Map.Entry<GraphSearchTraveledPath<?, ?>, ?> o1, Map.Entry<GraphSearchTraveledPath<?, ?>, ?> o2) {
            return -1 * Integer.compare(o1.getKey().path.getTransitionsCount(), o2.getKey().path.getTransitionsCount());
        }
    };
    public static GraphSearchExtendAlgorithm EXTEND_WHEN_ONLY_ONE_OPTION_AVAILALBE = new GraphSearchExtendAlgorithm(){

        public void extendSearchFront(GraphSearcher search, List possibleExtends, Collection selectedExtends, Collection closedExtends) {
            if (possibleExtends.size() == 1) {
                selectedExtends.add(possibleExtends.get(0));
            }
        }
    };
    protected static final SimplePublish2<List<Map.Entry>, Collection<Map.Entry>> EXTEND_ALL_SELECTOR = new SimplePublish2<List<Map.Entry>, Collection<Map.Entry>>(){

        @Override
        public void publish(List<Map.Entry> a, Collection<Map.Entry> b) {
            CollectionTools.copyInto(a, b);
        }
    };
    public static final GraphSearchExtendAlgorithm EXTEND_ALL = new GraphSearchExtendAlgorithm(){

        public void extendSearchFront(GraphSearcher search, List possibleExtends, Collection selectedExtends, Collection closedExtends) {
            selectedExtends.addAll(possibleExtends);
        }
    };

    public static <V, E> GraphSearchAlgorithm<V, E> depthFirstHeuristic(final GetBy2<Long, V, V> toDestinationCostToMinimize) {
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                BulkTransitMap select = new BulkTransitMap();
                long lowest = Long.MAX_VALUE;
                Object dst = search.getFirstDestination();
                Collections.sort(possibleExtends, GraphSearchAlgorithms.getComparatorOrdersSearchPathLength());
                int max = possibleExtends.get((int)0).getKey().path.getTransitionsCount();
                for (int i = 0; i < possibleExtends.size(); ++i) {
                    Map.Entry e = possibleExtends.get(i);
                    if (max != e.getKey().path.getTransitionsCount()) break;
                    long l = (Long)toDestinationCostToMinimize.getBy(e.getValue().getValue(), dst);
                    if (l < lowest) {
                        lowest = l;
                    }
                    select.put(e, l);
                }
                for (Map.Entry kv : select.entrySet()) {
                    if (!((Long)kv.getValue()).equals(lowest)) continue;
                    selectedExtends.add(kv.getKey());
                    return;
                }
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                return false;
            }

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
                search.initForwardSearch();
            }
        };
    }

    public static final <V, E> Comparator<Map.Entry<GraphSearchTraveledPath<V, E>, V>> getComparatorOrdersSearchPathLength() {
        return ORDER_BY_GRAPH_PATH_LENGTH;
    }

    public static <V, E> boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
        MultiMap<V, GraphSearchTraveledPath<V, E>> forward = new MultiMap<V, GraphSearchTraveledPath<V, E>>();
        MultiMap<V, GraphSearchTraveledPath<V, E>> backward = new MultiMap<V, GraphSearchTraveledPath<V, E>>();
        block4: for (GraphSearchTraveledPath<V, E> s : search.getOpenBranches()) {
            switch (s.getSearchDirection()) {
                case BACKWARD: {
                    backward.put(s.getDirectionVertex(), s);
                    continue block4;
                }
                case BIDIRECTIONAL: 
                case FORWARD: {
                    forward.put(s.getDirectionVertex(), s);
                    continue block4;
                }
            }
            throw new UnimplementedCaseException(s.getSearchDirection());
        }
        boolean mergeHappened = false;
        for (Map.Entry f : forward.multiEntrySet()) {
            List lst = backward.getList(f.getKey());
            if (null == lst) continue;
            for (GraphSearchTraveledPath m1 : f.getValue()) {
                for (GraphSearchTraveledPath m2 : lst) {
                    mergePairs.add(new KeyVal<GraphSearchTraveledPath, GraphSearchTraveledPath>(m1, m2));
                    mergeHappened = true;
                }
            }
        }
        return mergeHappened;
    }

    public static <V, E> GraphSearchAlgorithm<V, E> beforeOriginalExtend(final GraphSearchAlgorithm<V, E> original, final GraphSearchExtendAlgorithm<V, E> ... selects) {
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
                original.initSearch(search);
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                return original.mergeBranches(search, mergePairs);
            }

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                ArrayList pe = new ArrayList();
                Set decided = Collections.newSetFromMap(new IdentityHashMap());
                pe.addAll(possibleExtends);
                for (GraphSearchExtendAlgorithm select : selects) {
                    pe.removeAll(decided);
                    select.extendSearchFront(search, pe, selectedExtends, closedExtends);
                    decided.addAll(selectedExtends);
                    decided.addAll(closedExtends);
                }
                pe.removeAll(decided);
                original.extendSearchFront(search, pe, selectedExtends, closedExtends);
            }
        };
    }

    public static <V, E> SimplePublish2<List<Map.Entry<GraphSearchTraveledPath<V, E>, V>>, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, V>>> getExtendAllSelector() {
        return EXTEND_ALL_SELECTOR;
    }

    public static <V, E> GraphSearchAlgorithm<V, E> fromExtend(final GraphSearchExtendAlgorithm<V, E> ext) {
        return new GraphSearchAlgorithm<V, E>(){

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                ext.extendSearchFront(search, possibleExtends, selectedExtends, closedExtends);
            }

            @Override
            public void initSearch(GraphSearcher<V, E> search) {
            }

            @Override
            public boolean mergeBranches(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, GraphSearchTraveledPath<V, E>>> mergePairs) {
                return false;
            }
        };
    }

    public static <V, E> GraphSearchExtendAlgorithm<V, E> closeVisitedState(final GetBy2<Boolean, GraphSearcher<V, E>, Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> select) {
        return new GraphSearchExtendAlgorithm<V, E>(){

            @Override
            public void extendSearchFront(GraphSearcher<V, E> search, List<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> possibleExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> selectedExtends, Collection<Map.Entry<GraphSearchTraveledPath<V, E>, Map.Entry<E, V>>> closedExtends) {
                for (Map.Entry ext : possibleExtends) {
                    if (Boolean.TRUE != select.getBy(search, ext)) continue;
                    closedExtends.add(ext);
                }
            }
        };
    }
}

