/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.cli;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.exceptions.CheckedIllegalArgumentException;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CliTools {
    protected static Map<String, List<String>> CLI_OPTIONS = null;

    private CliTools() {
    }

    public static Map<String, List<String>> parseCliOpts(String ... args) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        ArrayList<String> options = null;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.charAt(0) == '-') {
                if (a.length() < 2) {
                    throw new IllegalArgumentException("Error at argument " + a);
                }
                options = new ArrayList<String>();
                params.put(a.substring(1), options);
                continue;
            }
            if (options != null) {
                options.add(a);
                continue;
            }
            throw new IllegalArgumentException("Illegal parameter usage: " + a);
        }
        return params;
    }

    public static String renderListAllOption(CliEntry ... ent) {
        StringBuilder sb = new StringBuilder();
        for (CliEntry e : ent) {
            sb.append(e.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static <T> GetBy2<T, CliEntry<T>, Map<String, List<String>>> createParser(GetBy1<T, String> parser, GetBy1<String, Map<String, List<String>>> examiner) {
        return (a, b) -> {
            String ret = (String)examiner.getBy((Map<String, List<String>>)b);
            if (null != ret) {
                return parser.getBy(ret);
            }
            return null;
        };
    }

    public static String getFirstUnknownParam(Map<String, List<String>> pa, CliEntry ... ents) {
        HashSet opts = new HashSet();
        for (CliEntry ent : ents) {
            CollectionTools.copyInto(ent.getOptionNames(), opts);
        }
        for (String s : pa.keySet()) {
            if (opts.contains(s)) continue;
            return s;
        }
        return null;
    }

    public static Map<String, List<String>> storeCliOptions(boolean override, String ... args) throws CheckedIllegalArgumentException {
        if (null == CLI_OPTIONS || override) {
            Map<String, List<String>> parsed = CliTools.parseCliOpts(args);
            Map<String, List<String>> store = new HashMap();
            for (Map.Entry<String, List<String>> kv : parsed.entrySet()) {
                store.put(kv.getKey(), Collections.unmodifiableList(kv.getValue()));
            }
            store = Collections.unmodifiableMap(store);
            CLI_OPTIONS = store;
        }
        return CLI_OPTIONS;
    }

    public static Map<String, List<String>> getStoredCliOptions() {
        return CLI_OPTIONS;
    }
}

