/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.enumerations;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SimpleFixedEnumManager<E extends EnumLike<E>>
implements EnumManager<E> {
    protected List<E> cnst;
    final HashMap<String, E> byName = new HashMap();

    public SimpleFixedEnumManager(List<E> from) {
        this.cnst = new ArrayList<E>(from);
        int i = 0;
        for (EnumLike c : this.cnst) {
            this.byName.put(c.getName(), c);
            AssertArgument.assertEquals(i++, c.getOrdinal(), "enum_oridnal");
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.cnst.iterator();
    }

    @Override
    public void registerElement(E elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E getByOrdinal(int ord) {
        return (E)((EnumLike)this.cnst.get(ord));
    }

    @Override
    public E getByName(String name) {
        return (E)((EnumLike)this.byName.get(name));
    }

    @Override
    public Object[] getValues() {
        return this.cnst.toArray();
    }

    @Override
    public E[] getValues(E[] arr) {
        return (EnumLike[])this.cnst.toArray(arr);
    }

    @Override
    public List<E> getValueList() {
        return this.cnst;
    }

    public String toString() {
        return "SimpleFixedEnumManager";
    }
}

