/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.set.ArrayListSeemsSet;
import eu.javaexperience.interfaces.simple.SimpleGet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MultiCollectionMap<K, V>
implements Map<K, V> {
    protected final Map<K, Collection<V>> back;
    protected final SimpleGet<Collection<V>> collectionCreator;

    public MultiCollectionMap(Map<K, Collection<V>> back, SimpleGet<Collection<V>> listCreator) {
        this.back = back;
        this.collectionCreator = listCreator;
    }

    @Override
    public int size() {
        return this.back.size();
    }

    @Override
    public boolean isEmpty() {
        return this.back.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.back.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> kv : this.entrySet()) {
            V v = kv.getValue();
            if (null == v || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Collection<V> get = this.back.get(key);
        if (null != get && get.size() > 0) {
            return CollectionTools.tryGetFirst(get);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Collection<V> get = this.back.get(key);
        if (null == get) {
            get = this.collectionCreator.get();
            this.back.put(key, get);
        }
        get.add(value);
        return null;
    }

    public V preserv(K key) {
        Collection<V> get = this.back.get(key);
        if (null == get) {
            get = this.collectionCreator.get();
            this.back.put(key, get);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        Collection<V> ret = this.back.remove(key);
        if (null != ret && ret.size() > 0) {
            return CollectionTools.tryGetFirst(ret);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> kv : m.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void clear() {
        this.back.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.back.keySet();
    }

    @Override
    public Collection<V> values() {
        Collection<Collection<V>> get = this.back.values();
        if (null == get) {
            return null;
        }
        ArrayList<V> ret = new ArrayList<V>();
        for (Collection<V> vs : get) {
            if (null == vs) continue;
            for (V v : vs) {
                ret.add(v);
            }
        }
        return ret;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ArrayListSeemsSet<Map.Entry<K, V>> ret = new ArrayListSeemsSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Collection<V>> kvvs : this.back.entrySet()) {
            K k = kvvs.getKey();
            Collection<V> vs = kvvs.getValue();
            if (null == vs) continue;
            for (V v : vs) {
                ret.add(new KeyVal<K, V>(k, v));
            }
        }
        return ret;
    }

    public Set<Map.Entry<K, Collection<V>>> multiEntrySet() {
        return this.back.entrySet();
    }

    public Collection<V> getCollection(Object key) {
        return this.back.get(key);
    }
}

