/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.ImprovedMap;
import eu.javaexperience.collection.map.MapTools;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RWLockMap<K, V>
implements ConcurrentMap<K, V>,
ImprovedMap<K, V> {
    protected final Map<K, V> map;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected ReentrantReadWriteLock.ReadLock rl = this.lock.readLock();
    protected ReentrantReadWriteLock.WriteLock wl = this.lock.writeLock();

    public RWLockMap(Map<K, V> map) {
        this.map = map;
        AssertArgument.assertNotNull(this.map, "map");
    }

    @Deprecated
    public ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.rl;
    }

    @Deprecated
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.wl;
    }

    @Deprecated
    public Map<K, V> getBackendMap() {
        return this.map;
    }

    @Override
    public int size() {
        this.rl.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.rl.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.rl.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.rl.lock();
        try {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.rl.lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.wl.lock();
        try {
            V v = this.map.put(key, value);
            return v;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.wl.lock();
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.wl.lock();
        try {
            this.map.putAll(m);
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public void clear() {
        this.wl.lock();
        try {
            this.map.clear();
        }
        finally {
            this.wl.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.rl.lock();
        try {
            Set<K> set = this.map.keySet();
            return set;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.rl.lock();
        try {
            Collection<V> collection = this.map.values();
            return collection;
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.rl.lock();
        try {
            Set<Map.Entry<K, V>> set = this.map.entrySet();
            return set;
        }
        finally {
            this.rl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.wl.lock();
        try {
            if (!this.map.containsKey(key)) {
                V v = this.map.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.wl.lock();
        try {
            V in = this.map.get(key);
            if (null != value && value.equals(in)) {
                this.map.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.wl.lock();
        try {
            V in = this.map.get(key);
            if (null != in && in.equals(oldValue)) {
                this.map.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.wl.lock();
        try {
            if (this.map.containsKey(key)) {
                V v = this.map.put(key, value);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyAll(Map<? super K, ? super V> dst) {
        this.rl.lock();
        try {
            int len = dst.size();
            dst.putAll(this.map);
            int n = dst.size() - len;
            return n;
        }
        finally {
            this.rl.unlock();
        }
    }

    public String toString() {
        return "ReentrantMap:" + MapTools.toStringMultiline(this);
    }
}

