/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.mysql;

import eu.javaexperience.database.JDBC;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MysqlIndexMap {
    protected String table;
    protected ArrayList<MysqlIndexRow> indexes = null;

    public static Map<String, MysqlIndexMap> loadAllTableIndex(Connection conn) throws SQLException, IllegalArgumentException, IllegalAccessException {
        ArrayList tables = new ArrayList();
        JDBC.getAsList(conn, "SHOW TABLES;", tables);
        HashMap<String, MysqlIndexMap> ret = new HashMap<String, MysqlIndexMap>();
        for (String t : tables) {
            ret.put(t, MysqlIndexMap.load(conn, t));
        }
        return ret;
    }

    public static MysqlIndexMap load(Connection conn, String table) throws SQLException, IllegalArgumentException, IllegalAccessException {
        MysqlIndexMap ret = new MysqlIndexMap();
        ret.table = table;
        try (Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery("SHOW INDEXES FROM `" + table + "`;");){
            ArrayList<MysqlIndexRow> rows = new ArrayList<MysqlIndexRow>();
            while (rs.next()) {
                MysqlIndexRow n = new MysqlIndexRow();
                JDBC.simpleReadIntoJavaObject(rs, MysqlIndexRow.SQL_FIELDS, n);
                rows.add(n);
            }
            ret.indexes = rows;
        }
        return ret;
    }

    public boolean hasIndexNamed(String indexName) {
        for (MysqlIndexRow row : this.indexes) {
            if (!indexName.equals(row.Key_name)) continue;
            return true;
        }
        return false;
    }

    protected static class MysqlIndexRow {
        public String Table;
        public Integer Non_unique;
        public String Key_name;
        public Integer Seq_in_index;
        public String Column_name;
        public String Collation;
        public Long Cardinality;
        public String Sub_part;
        public String Packed;
        public Boolean Null;
        public String Index_type;
        public String Comment;
        public String Index_comment;
        private static final Field[] SQL_FIELDS = Mirror.getClassData(MysqlIndexRow.class).selectFields(new Mirror.FieldSelector(false, Mirror.Visibility.Public, Mirror.BelongTo.Instance, Mirror.Select.All, Mirror.Select.All, Mirror.Select.All));

        protected MysqlIndexRow() {
        }
    }
}

