/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.environment;

import eu.javaexperience.text.StringTools;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EnvironmentTools {
    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static int getCurrentProcessPid() {
        try {
            String pp = new File("/proc/self").getCanonicalFile().toString();
            pp = StringTools.getSubstringAfterLastString(pp, "/", null);
            if (null != pp) {
                return Integer.valueOf(pp);
            }
        }
        catch (Exception pp) {
            // empty catch block
        }
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            String spid = StringTools.getSubstringBeforeFirstString(jvmName, "@", null);
            if (null != spid) {
                Integer.valueOf(spid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("Can't determine current process pid");
    }

    public static String getOperationSystemType() {
        return System.getProperty("os.name");
    }
}

