/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.file.fs.classloader;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.AbstractFileSystem;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.file.fs.classloader.ClassLoaderFileSystem;
import eu.javaexperience.file.fs.os.OsFile;
import eu.javaexperience.io.IOTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class ClassLoaderFile
implements AbstractFile {
    protected ClassLoaderFileSystem clfs;
    protected String file;

    public ClassLoaderFile(ClassLoaderFileSystem clfs, String file) {
        this.clfs = clfs;
        this.file = file;
    }

    @Override
    public String getUrl() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public AbstractFileSystem getFileSystem() {
        return this.clfs;
    }

    @Override
    public AbstractFile getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public boolean delete() throws IOException {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public boolean setLastModified(long time) throws IOException {
        return false;
    }

    @Override
    public boolean exists() {
        return null != this.clfs.cl.getResource(this.file);
    }

    @Override
    public boolean createNewRegularFile() throws IOException {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return this.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getSize() {
        try (InputStream r = this.openRead();){
            long l = IOTools.copyStream(r, IOTools.nullOutputStream);
            return l;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public File tryGetFile() {
        URL u = this.clfs.cl.getResource(this.file);
        if (null != u) {
            return new File(u.getFile());
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        File f = this.tryGetFile();
        if (null == f) {
            return false;
        }
        return f.isDirectory();
    }

    @Override
    public AbstractFile[] listFiles() {
        File f = this.tryGetFile();
        if (null == f) {
            return null;
        }
        return FileSystemTools.warpFiles(f.listFiles());
    }

    @Override
    public boolean mkdir() throws IOException {
        return false;
    }

    @Override
    public boolean mkdirs() throws IOException {
        return false;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public InputStream openRead() throws IOException {
        return this.clfs.cl.getResourceAsStream(this.file);
    }

    @Override
    public OutputStream openWrite(boolean append) throws IOException {
        throw new UnsupportedOperationException("Can't open ClassLoaderFile for write: " + this.file);
    }

    public String toString() {
        return "ClassLoaderFile: " + this.file;
    }

    public int hashCode() {
        return this.clfs.hashCode() ^ this.file.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassLoaderFile)) {
            return false;
        }
        ClassLoaderFile other = (ClassLoaderFile)obj;
        return other.clfs.equals(this.clfs) && other.file.equals(this.file);
    }

    @Override
    public AbstractFile getParentFile() {
        File f = this.tryGetFile();
        if (null == f) {
            return null;
        }
        return new OsFile(f.getParentFile());
    }
}

