/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.file.fs.os;

import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.AbstractFileSystem;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.semantic.references.MayNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OsFile
implements AbstractFile {
    protected final File file;

    public OsFile(File f) {
        this.file = f;
    }

    public OsFile(String f) {
        this.file = new File(f);
    }

    @Override
    public String getUrl() {
        return this.file.toString();
    }

    @Override
    public AbstractFileSystem getFileSystem() {
        return FileSystemTools.DEFAULT_FILESYSTEM;
    }

    @Override
    public AbstractFile getCanonicalFile() throws IOException {
        File ret = this.file.getCanonicalFile();
        if (null == ret) {
            return null;
        }
        return new OsFile(ret);
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    @MayNull
    public AbstractFile[] listFiles() {
        File[] r = this.file.listFiles();
        if (null == r) {
            return null;
        }
        AbstractFile[] ret = new AbstractFile[r.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new OsFile(r[i]);
        }
        return ret;
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public boolean createNewRegularFile() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public InputStream openRead() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openWrite(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.file, append);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isRegularFile() {
        return this.file.isFile();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public AbstractFile getParentFile() {
        File p = this.file.getParentFile();
        if (null == p) {
            return null;
        }
        return new OsFile(p);
    }

    public String toString() {
        return this.file.toString();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OsFile)) {
            return false;
        }
        return this.file.equals(((OsFile)obj).file);
    }

    public File getFile() {
        return this.file;
    }
}

