/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileConfigMapper
implements Map<String, String> {
    protected final File dir;
    protected final String path;

    public FileConfigMapper(File dir) {
        AssertArgument.assertNotNull(dir, "dir");
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Given file is not directory");
        }
        this.dir = dir;
        this.path = dir.toString() + "/";
    }

    @Override
    public int size() {
        return this.dir.list().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        return new File(this.path + key).exists();
    }

    @Override
    public boolean containsValue(Object value) {
        for (String k : this.dir.list()) {
            if (!value.equals(this.get(k))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        if (null == key || !this.containsKey(key)) {
            return null;
        }
        try {
            return IOTools.getFileContents(this.path + key);
        }
        catch (Exception e) {
            Mirror.throwSoftOrHardButAnyway(e);
            return null;
        }
    }

    @Override
    public String put(String key, String value) {
        try {
            IOTools.putFileContent(this.path + key, false, value.getBytes());
        }
        catch (IOException e) {
            Mirror.throwSoftOrHardButAnyway(e);
        }
        return null;
    }

    @Override
    public String remove(Object key) {
        if (null == key) {
            return null;
        }
        new File(this.path + key).delete();
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        MapTools.putAll(m, this);
    }

    @Override
    public void clear() {
        for (File f : this.dir.listFiles()) {
            f.delete();
        }
    }

    @Override
    public Set<String> keySet() {
        return CollectionTools.inlineAdd(new HashSet(), this.dir.list());
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> ret = new ArrayList<String>();
        for (String k : this.dir.list()) {
            String re = this.get(k);
            if (null == re) continue;
            ret.add(re);
        }
        return ret;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> ret = new HashSet<Map.Entry<String, String>>();
        for (String s : this.dir.list()) {
            ret.add(new LazyEntry(s));
        }
        return ret;
    }

    protected class LazyEntry
    implements Map.Entry<String, String> {
        protected String key;

        protected LazyEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return FileConfigMapper.this.get(this.key);
        }

        @Override
        public String setValue(String value) {
            return FileConfigMapper.this.put(this.key, value);
        }
    }
}

