/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.io;

import eu.javaexperience.io.SerializationTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FileLinkedList<T extends Serializable>
implements Iterable<Link<T>> {
    protected final File dir;
    protected Set<Link<T>> entrys = new HashSet<Link<T>>();
    protected final Set<Link<T>> headLinks = new HashSet<Link<T>>();
    protected final Set<Link<T>> tailLinks = new HashSet<Link<T>>();
    protected int max_id = 0;

    public FileLinkedList(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Given file is not a directory");
        }
        this.dir = dir;
        this.load();
    }

    protected void load() {
        String[] files = this.dir.list();
        HashMap link_registry = new HashMap();
        for (String f : files) {
            int index = f.indexOf(46);
            if (index < 1) continue;
            String s1 = f.substring(0, index);
            String s2 = f.substring(index + 1, f.length());
            int id = Integer.parseInt(s1);
            int pid = Integer.parseInt(s2);
            Link l = new Link(this);
            l.id = id;
            if (this.max_id < id) {
                this.max_id = id;
            }
            l.tmp_parent_id = pid;
            link_registry.put(id, l);
            this.entrys.add(l);
        }
        for (Link link : this.entrys) {
            if (0 == link.tmp_parent_id) continue;
            Link parent = (Link)link_registry.get(link.tmp_parent_id);
            if (parent == link) {
                parent = null;
            }
            if (null == parent) {
                link.on_parent_not_found(link.tmp_parent_id);
                continue;
            }
            link.parent = parent;
            ++parent.refcount;
        }
        for (Link link : this.entrys) {
            link.file = link.generateFileName();
            if (null == link.parent) {
                this.headLinks.add(link);
            }
            if (link.refcount != 0) continue;
            this.tailLinks.add(link);
        }
    }

    public void fillHeadLinks(Collection<Link<T>> heads) {
        heads.addAll(this.headLinks);
    }

    public void fillTailLinks(Collection<Link<T>> tails) {
        tails.addAll(this.tailLinks);
    }

    public Link<T> newLink(@MayNull Link<T> parent) {
        Link<T> l = new Link<T>(this, ++this.max_id, parent);
        return l;
    }

    @Override
    public Iterator<Link<T>> iterator() {
        return this.entrys.iterator();
    }

    public static class Link<T extends Serializable> {
        protected transient int tmp_parent_id;
        protected transient int refcount;
        protected final FileLinkedList<T> owner;
        protected int id;
        protected File file;
        protected Link<T> parent;

        protected Link(FileLinkedList<T> owner) {
            this.owner = owner;
        }

        protected Link(FileLinkedList<T> owner, int id, Link<T> parent) {
            this(owner);
            this.id = id;
            this.setParent(parent, true);
            this.touch();
            owner.entrys.add(this);
            owner.tailLinks.add(this);
        }

        protected int getParentId() {
            if (null == this.parent) {
                return 0;
            }
            return this.parent.id;
        }

        protected boolean touch() {
            try {
                return this.file.createNewFile();
            }
            catch (IOException e) {
                Mirror.throwSoftOrHardButAnyway(e);
                return false;
            }
        }

        public FileLinkedList<T> getOwner() {
            return this.owner;
        }

        public File _generateFileName(int parent) {
            return new File(this.owner.dir + "/" + this.id + "." + parent);
        }

        public File generateFileName() {
            return this._generateFileName(this.getParentId());
        }

        public T getContent() {
            return (T)SerializationTools.deserializeFromFile(this.file);
        }

        public void setContent(T elem) {
            SerializationTools.serializeIntoFile(this.file, elem);
        }

        public Link<T> getParent() {
            return this.parent;
        }

        public boolean isRootNode() {
            return null == this.parent;
        }

        public boolean isEndpoint() {
            return this.owner.tailLinks.contains(this);
        }

        public void setParent(Link<T> l) {
            this.setParent(l, false);
        }

        protected void setParent(Link<T> l, boolean first) {
            if (!first && this.parent == l) {
                return;
            }
            if (null != l && this.owner != l.owner) {
                throw new RuntimeException("Mixing Link<T> between different FileLinkedList is an illegal operation. (yet)");
            }
            if (null == this.parent) {
                this.owner.headLinks.remove(this);
            } else {
                --this.parent.refcount;
                if (0 == this.parent.refcount) {
                    this.owner.tailLinks.add(this.parent);
                }
            }
            if (null == l) {
                this.owner.headLinks.add(this);
            } else {
                ++l.refcount;
                if (l.isEndpoint()) {
                    this.owner.tailLinks.remove(l);
                    this.owner.tailLinks.add(this);
                }
            }
            this.parent = l;
            if (!first) {
                File oldFile = this.file;
                this.file = this.generateFileName();
                FileTools.move(oldFile, this.file);
            } else {
                this.file = this.generateFileName();
            }
        }

        protected void on_parent_not_found(int parent) {
            File old = this._generateFileName(parent);
            this.parent = null;
            this.file = this.generateFileName();
            FileTools.move(old, this.file);
        }
    }
}

