/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.log;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.LocklessPrintWriter;
import eu.javaexperience.log.DayliLogrotaOutput;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LogOutput;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggerProvider;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.log.ThreadLocalHookableLogFacility;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.resource.ReferenceCounted;
import eu.javaexperience.text.Format;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.time.TimeCalc;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class JavaExperienceLoggingFacility {
    protected static Vector<LogOutput> OUTPUTS = new Vector();
    public static final LogOutput[] emptyLogOutputArrays = new LogOutput[0];
    protected static final LoggingDetailLevel DEFAULT_LEVEL = JavaExperienceLoggingFacility.lookupDefaultLoglevel();
    protected static LoggerProvider JEX = new LoggerProvider(new LogOutput(){

        @Override
        public ReferenceCounted<PrintWriter> getLogOutput() throws IOException {
            LocklessPrintWriter lpw = new LocklessPrintWriter(IOTools.nullOutputStream, false){

                @Override
                public void write(char[] csq, int start, int end) {
                    LogOutput[] los;
                    for (LogOutput lo : los = OUTPUTS.toArray(emptyLogOutputArrays)) {
                        try (ReferenceCounted<PrintWriter> rc_pw = lo.getLogOutput();){
                            PrintWriter pw = rc_pw.getSubject();
                            pw.write(csq, start, end);
                            pw.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            };
            return new ReferenceCounted<PrintWriter>((PrintWriter)lpw, 2){

                @Override
                protected void onFree() {
                }
            };
        }
    });
    static final Logger LOG = JEX.createLoggerFor(new Loggable("JavaExperienceDefaultLogginFacility", JavaExperienceLoggingFacility.getDefaultLogLevel()));
    public static final Logger DEFAULT_LOGGER = new Logger(){

        protected void refuse() {
            throw new RuntimeException("Cannot modify JavaExperienceDefaultLogginFacility");
        }

        @Override
        public void setLogLevel(LoggingDetailLevel level) {
            this.refuse();
        }

        @Override
        public boolean mayLog(LoggingDetailLevel level) {
            return LOG.mayLog(level);
        }

        @Override
        public void logFormat(LoggingDetailLevel level, String formatString, Object ... params) {
            LOG.logFormat(level, formatString, params);
        }

        @Override
        public void logExceptionFormat(LoggingDetailLevel level, Throwable t, String format, Object ... params) {
            LOG.logExceptionFormat(level, t, format, params);
        }

        @Override
        public void logException(LoggingDetailLevel level, Throwable t) {
            LOG.logException(level, t);
        }

        @Override
        public void log(LoggingDetailLevel level, String str) {
            LOG.log(level, str);
        }

        @Override
        public LoggingDetailLevel getLogLevel() {
            return LOG.getLogLevel();
        }

        @Override
        public String getFacilityName() {
            return LOG.getFacilityName();
        }
    };
    protected static boolean STD_OUT_LOG_ADDED = false;
    private static boolean THREAD_LOCAL_OUTPUT_ADDED = false;
    protected static Map<String, LoggingDetailLevel> FUTURE_MODULE_LEVEL = new ConcurrentHashMap<String, LoggingDetailLevel>();
    protected static LoggingDetailLevel FUTURE_DEFAUL_LEVEL = null;

    protected static LoggingDetailLevel lookupDefaultLoglevel() {
        String ll = System.getenv("JVX_DEFAULT_LOG_LEVEL");
        if (null != ll) {
            LogLevel ret = EnumTools.recogniseSymbol(LogLevel.class, ll);
            if (null == ret) {
                System.out.println("Env variable `JVX_DEFAULT_LOG_LEVEL` specified as `" + ll + "` which is an unrecognisable loglevel. Available loglevels are: " + ArrayTools.toString(LogLevel.values()));
            } else {
                return ret;
            }
        }
        return LogLevel.MEASURE;
    }

    public static LoggingDetailLevel getDefaultLogLevel() {
        return DEFAULT_LEVEL;
    }

    public static Logger getLogger(LoggableUnitDescriptor descr) {
        Logger l = JavaExperienceLoggingFacility.getLoggingFacilityByName(descr.getUnitShortName());
        if (null != l) {
            return l;
        }
        l = JEX.createLoggerFor(descr);
        LoggingDetailLevel lvl = FUTURE_MODULE_LEVEL.get(descr.getUnitShortName());
        if (null != lvl) {
            l.setLogLevel(lvl);
        } else {
            lvl = FUTURE_DEFAUL_LEVEL;
            if (null != lvl) {
                l.setLogLevel(lvl);
            }
        }
        return l;
    }

    public static void addLogOutput(LogOutput out) {
        OUTPUTS.add(out);
    }

    public static synchronized void addStdOut() {
        if (!STD_OUT_LOG_ADDED) {
            STD_OUT_LOG_ADDED = true;
            JavaExperienceLoggingFacility.addLogOutput(LoggingTools.STDOUT_LOG_OUTPUT);
            LoggingTools.tryLogSimple(LOG, JavaExperienceLoggingFacility.getDefaultLogLevel(), "JavaExperienceLoggingFacility.addStdOut() called");
        }
    }

    public static synchronized void addThreadLocalHookableLoggerOutput() {
        if (!THREAD_LOCAL_OUTPUT_ADDED) {
            JavaExperienceLoggingFacility.addLogOutput(ThreadLocalHookableLogFacility.LOG_OUTPUT);
            LoggingTools.tryLogSimple(LOG, JavaExperienceLoggingFacility.getDefaultLogLevel(), "JavaExperienceLoggingFacility.addThreadLocalHookableLoggerOutput() called");
            THREAD_LOCAL_OUTPUT_ADDED = true;
        }
    }

    public static void listIssuedLoggers(Collection<Logger> facilities) {
        JEX.fillActiveLoggers(facilities);
    }

    public static void setFutureModuleDefaultLoglevel(String module, LoggingDetailLevel lvl) {
        if (null != module && null != lvl) {
            FUTURE_MODULE_LEVEL.put(module, lvl);
            Logger l = JavaExperienceLoggingFacility.getLoggingFacilityByName(module);
            if (null != l) {
                l.setLogLevel(lvl);
            }
        }
    }

    public static void setFutureDefaultLoglevel(LoggingDetailLevel lvl) {
        FUTURE_DEFAUL_LEVEL = lvl;
    }

    public static Logger getLoggingFacilityByName(String name) {
        ArrayList<Logger> lfs = new ArrayList<Logger>();
        JEX.fillActiveLoggers(lfs);
        for (Logger lf : lfs) {
            if (!name.equals(lf.getFacilityName())) continue;
            return lf;
        }
        return null;
    }

    public static void loadDefaultFacilityLogLevelsFromPropertyWithPrefix(Properties prop, String prefix) {
        JavaExperienceLoggingFacility.loadDefaultFacilityLogLevelsFromPropertyWithPrefix(prop.entrySet(), prefix);
    }

    public static void loadDefaultFacilityLogLevelsFromPropertyWithPrefix(Set<Map.Entry<Object, Object>> allPropertySet, String prefix) {
        String pre = prefix + ".";
        for (Map.Entry<Object, Object> kv : allPropertySet) {
            LogLevel lvl;
            String k;
            if (null == kv.getKey() || null == kv.getValue() || !(k = kv.getKey().toString()).startsWith(pre) || (k = StringTools.getSubstringAfterFirstString(k, pre)).contains(".") || null == (lvl = ParsePrimitive.tryParseEnum(LogLevel.class, kv.getValue().toString()))) continue;
            JavaExperienceLoggingFacility.setFutureModuleDefaultLoglevel(k, lvl);
        }
    }

    public static void setAllFacilityLoglevel(final LogLevel lvl) {
        JEX.fillActiveLoggers((Collection<Logger>)new PublisherCollection<Logger>(){

            @Override
            public boolean add(Logger lf) {
                lf.setLogLevel(lvl);
                return false;
            }
        });
    }

    public static void startLoggingIntoDirectory(File directory, String prefix) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        JavaExperienceLoggingFacility.addLogOutput(new DayliLogrotaOutput(directory + "/" + prefix));
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    long jvmStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
                    long now = System.currentTimeMillis();
                    LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.INFO, "JavaExperienceLoggingFacility JVM start time: %s, JVM shutdownHook time: %s, full time: %s", (Object)Format.UTC_SQL_TIMESTAMP_MS.format(new Date(jvmStartTime)), (Object)Format.UTC_SQL_TIMESTAMP_MS.format(new Date(now)), (Object)(TimeCalc.durationToHourMinSec(now - jvmStartTime) + " h:m:s"));
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

