/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.log;

import eu.javaexperience.collection.map.ConcurrentMapTools;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.log.AbstractLogger;
import eu.javaexperience.log.DayliLogrotaOutput;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LogOutput;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggerFactory;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.resource.ReferenceCounted;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class LoggerProvider
implements LoggerFactory {
    protected final LogOutput out;
    protected final ConcurrentHashMap<LoggableUnitDescriptor, Logger> LFS = new ConcurrentHashMap();

    public static LoggerProvider logIntoDirectory(File dir, String logfilePerfix) {
        return new LoggerProvider(new DayliLogrotaOutput(dir + "/" + logfilePerfix));
    }

    public LoggerProvider(LogOutput lo) {
        this.out = lo;
    }

    @Override
    public Logger createLoggerFor(LoggableUnitDescriptor unit) {
        return ConcurrentMapTools.getOrCreate(this.LFS, unit, new GetBy1<Logger, LoggableUnitDescriptor>(){

            @Override
            public Logger getBy(LoggableUnitDescriptor a) {
                return new AbstractLogger(a){

                    @Override
                    protected void doLog(String toLog) {
                        try (ReferenceCounted<PrintWriter> rc_pw = LoggerProvider.this.out.getLogOutput();){
                            rc_pw.getSubject().println(toLog);
                        }
                        catch (Exception e) {
                            LoggingTools.tryLogSimple(JavaExperienceLoggingFacility.LOG, (LoggingDetailLevel)LogLevel.WARNING, e);
                        }
                    }
                };
            }
        });
    }

    @Override
    public void fillActiveLoggers(Collection<Logger> facilities) {
        for (Logger lf : this.LFS.values()) {
            facilities.add(lf);
        }
    }
}

