/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.behavioral.mediator;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimplePublishTools;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish3;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.semantic.references.MayNull;
import java.util.ArrayList;

public class EventMediator<E> {
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("EventMediator"));
    protected final ArrayList<SimplePublish1<E>> listeners = new ArrayList();
    public static final SimplePublish3<SimplePublish1, Object, Throwable> DEFAULT_EXCEPTION_HANDLER = new SimplePublish3<SimplePublish1, Object, Throwable>(){

        @Override
        public void publish(SimplePublish1 a, Object b, Throwable c) {
            LoggingTools.tryLogFormatException(LOG, (LoggingDetailLevel)LogLevel.WARNING, c, "DefaultExceltionHandler: exception during dispatching: event `%s` to handler: `%s`", b, (Object)a);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventListener(SimplePublish1<E> listener) {
        AssertArgument.assertNotNull(listener, "listener");
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            if (this.listeners.contains(listener)) {
                return false;
            }
            this.listeners.add(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEventListener(SimplePublish1<E> listener) {
        AssertArgument.assertNotNull(listener, "listener");
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListenerRegistered(SimplePublish1<E> listener) {
        AssertArgument.assertNotNull(listener, "listener");
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            return this.listeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swapListenersToOrder(SimplePublish1<E> before, SimplePublish1<E> after) {
        AssertArgument.assertNotNull(before, "before listener");
        AssertArgument.assertNotNull(after, "after listener");
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            int a = this.listeners.indexOf(before);
            if (a < 0) {
                throw new RuntimeException("Listener \"before\" is not registered in the EventMediator");
            }
            int b = this.listeners.indexOf(after);
            if (b < 0) {
                throw new RuntimeException("Listener \"before\" is not registered in the EventMediator");
            }
            if (a < b) {
                return false;
            }
            this.listeners.set(a, before);
            this.listeners.set(b, after);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimplePublish1<E>[] getListeners() {
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            return this.listeners.toArray(SimplePublishTools.emptySimplePublish1Array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumbersOfListeners() {
        EventMediator eventMediator = this;
        synchronized (eventMediator) {
            return this.listeners.size();
        }
    }

    public void dispatchEvent(E event, @MayNull SimplePublish3<SimplePublish1<E>, E, Throwable> exceptionHandler) {
        AssertArgument.assertNotNull(event, "event to dispatch");
        for (SimplePublish1<E> l : this.getListeners()) {
            try {
                l.publish(event);
            }
            catch (Throwable e) {
                if (null == exceptionHandler) continue;
                exceptionHandler.publish(l, event, e);
            }
        }
    }

    public void dispatchEvent(E event) {
        this.dispatchEvent(event, DEFAULT_EXCEPTION_HANDLER);
    }

    public boolean hasListener() {
        return !this.listeners.isEmpty();
    }
}

