/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.patterns.creational.builder.unit;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.patterns.creational.builder.unit.InstanceBuilderFactory;
import java.util.EnumMap;
import java.util.Map;

public class InstanceBuilder<F extends Enum<F>, I> {
    protected final Class<F> fieldEnumClass;
    protected final EnumMap<F, Object> fieldData;
    protected final GetBy1<I, InstanceBuilder<F, I>> creator;

    public InstanceBuilder(Class<F> cls, GetBy1<I, InstanceBuilder<F, I>> creator) {
        this.fieldEnumClass = cls;
        this.fieldData = new EnumMap(cls);
        this.creator = creator;
    }

    public Class<F> getFieldEnumClass() {
        return this.fieldEnumClass;
    }

    public EnumMap<F, Object> getBuilderMap() {
        return this.fieldData;
    }

    public I build() {
        return this.creator.getBy(this);
    }

    public Object get(F field) {
        return this.fieldData.get(field);
    }

    public GetBy1<I, InstanceBuilder<F, I>> getCreator() {
        return this.creator;
    }

    public InstanceBuilder<F, I> clone() {
        InstanceBuilder<F, I> ret = new InstanceBuilder<F, I>(this.fieldEnumClass, this.creator);
        for (Map.Entry<F, Object> kv : this.fieldData.entrySet()) {
            ret.fieldData.put((F)((Enum)kv.getKey()), kv.getValue());
        }
        return ret;
    }

    public InstanceBuilderFactory<F, I> createFactory() {
        return new InstanceBuilderFactory(this.clone());
    }

    public InstanceBuilder<F, I> setField(F field, Object o) {
        this.fieldData.put(field, o);
        return this;
    }

    public InstanceBuilder<F, I> unsetField(F field) {
        this.fieldData.remove(field);
        return this;
    }

    public Object getField(F field) {
        return this.fieldData.get(field);
    }
}

