/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.query;

import eu.javaexperience.query.F;
import eu.javaexperience.reflect.CastTo;
import java.util.HashSet;
import java.util.Map;

public class AtomicCondition {
    private static final long serialVersionUID = 1L;
    private final F operator;
    private final boolean negate;
    private final String field;
    private final Object value;
    protected static final HashSet<String> fields = new HashSet();

    public AtomicCondition(F operator, boolean negate, String field, Object val) {
        this.operator = operator;
        this.negate = negate;
        this.field = field;
        this.value = val;
    }

    public F getOperator() {
        return this.operator;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public String getFieldName() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.field + " " + (this.negate ? "!" : "") + this.operator.name() + " " + this.value;
    }

    public static AtomicCondition parse(Map<String, Object> ac) {
        F op = F.valueOf((String)ac.get("o"));
        boolean neg = (Boolean)CastTo.Boolean.cast(ac.get("n"));
        String f = (String)ac.get("f");
        Object val = ac.get("v");
        return new AtomicCondition(op, neg, f, val);
    }

    public void write(Map<String, Object> to) {
        to.put("o", this.operator.name());
        to.put("n", this.negate);
        to.put("f", this.field);
        to.put("v", this.value);
    }

    static {
        fields.add("o");
        fields.add("n");
        fields.add("f");
        fields.add("v");
    }
}

