/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.resource.pool;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.resource.pool.ResourcePool;
import eu.javaexperience.semantic.references.MayNull;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimplifiedResourcePool<T>
implements ResourcePool<T> {
    protected final ConcurrentLinkedQueue<T> free = new ConcurrentLinkedQueue();
    protected final SimpleGet<T> factory;
    protected final AtomicInteger issued = new AtomicInteger();

    public SimplifiedResourcePool(SimpleGet<T> factory) {
        this.factory = factory;
        AssertArgument.assertNotNull(this.factory, "factory");
    }

    @Override
    public T acquireResource() {
        T ret = this.free.poll();
        if (ret == null) {
            ret = this.factory.get();
        }
        this.issued.incrementAndGet();
        return ret;
    }

    @Override
    @MayNull
    public T pollResource() {
        T ret = this.free.poll();
        if (ret == null) {
            return null;
        }
        this.issued.incrementAndGet();
        return ret;
    }

    @Override
    public void releaseResource(T resource) {
        AssertArgument.assertNotNull(resource, "resource");
        this.free.add(resource);
        this.issued.decrementAndGet();
    }

    @Override
    public void destroyResource(T resource) {
        AssertArgument.assertNotNull(resource, "resource");
        this.issued.decrementAndGet();
    }

    @Override
    public int getFreeResourcesCount() {
        return this.free.size();
    }

    @Override
    public int getIssuedResourcesCount() {
        return this.issued.get();
    }

    @Override
    public int getResourceLimitCount() {
        return -1;
    }

    @Override
    @MayNull
    public T tryAcquireResource(long paramLong, TimeUnit paramTimeUnit) throws InterruptedException {
        return this.acquireResource();
    }
}

