/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.time;

import eu.javaexperience.semantic.designedfor.Immutable;
import eu.javaexperience.semantic.references.MayNotModified;
import eu.javaexperience.text.Format;
import eu.javaexperience.time.TimeCalc;
import java.util.Date;

@Immutable
public class TimeLineElement<T> {
    transient T prev;
    transient T next;
    transient Date dFrom;
    transient Date dTo;
    @MayNotModified
    protected long from;
    @MayNotModified
    protected long to;

    public TimeLineElement(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("The end date must be after the start date. from: " + Format.sqlTimestamp(new Date(from)) + ", to: " + Format.sqlTimestamp(new Date(to)));
        }
        this.from = from;
        this.to = to;
    }

    public TimeLineElement(Date from, Date to) {
        this(from.getTime(), to.getTime());
        this.dFrom = from;
        this.dTo = to;
    }

    public T getPrev() {
        return this.prev;
    }

    public T getNext() {
        return this.next;
    }

    public final long duration() {
        return this.to - this.from;
    }

    public final boolean isIn(Date d) {
        return this.isIn(d.getTime());
    }

    public final boolean isIn(long d) {
        return this.from < d && d < this.to;
    }

    public final boolean isBTW(long from, long to) {
        return from <= this.from && this.to <= to;
    }

    public final boolean isBTW(Date from, Date to) {
        return this.isBTW(from.getTime(), to.getTime());
    }

    public final boolean hasCommonSectionWith(TimeLineElement<?> e) {
        return e.from < this.to && e.to > this.from;
    }

    public final boolean isAfter(long time) {
        return this.from >= time;
    }

    public final boolean isBefore(long time) {
        return this.to <= time;
    }

    public final boolean isAfter(TimeLineElement<?> time) {
        return this.isAfter(time.to);
    }

    public final boolean isBefore(TimeLineElement<?> time) {
        return this.isBefore(time.from);
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public Date getDateFrom() {
        if (this.dFrom == null) {
            this.dFrom = new Date(this.from);
        }
        return this.dFrom;
    }

    public Date getDateTo() {
        if (this.dTo == null) {
            this.dTo = new Date(this.to);
        }
        return this.dTo;
    }

    public String toString() {
        return "from: " + Format.sqlTimestamp(this.getDateFrom()) + ", to: " + Format.sqlTimestamp(this.getDateTo()) + ", dur: " + TimeCalc.durationToHourMin(this.duration());
    }
}

