/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.verify;

import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.verify.MultiValidationException;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import eu.javaexperience.verify.ValidationException;
import eu.javaexperience.verify.ValidationResultException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnvValidationFunctions {
    public static List<TranslationFriendlyValidationEntry> append(List<TranslationFriendlyValidationEntry> arr, TranslationFriendlyValidationEntry add) {
        if (null == arr) {
            arr = new ArrayList<TranslationFriendlyValidationEntry>();
        }
        arr.add(add);
        return arr;
    }

    public static List<TranslationFriendlyValidationEntry> append(List<TranslationFriendlyValidationEntry> arr, List<TranslationFriendlyValidationEntry> add) {
        if (null == arr) {
            arr = new ArrayList<TranslationFriendlyValidationEntry>();
        }
        arr.addAll(add);
        return arr;
    }

    public static List<TranslationFriendlyValidationEntry> appendOrThrow(List<TranslationFriendlyValidationEntry> arr, Throwable add) {
        if (add instanceof MultiValidationException) {
            return EnvValidationFunctions.append(arr, ((MultiValidationException)add).getResult());
        }
        if (add instanceof ValidationException) {
            return EnvValidationFunctions.append(arr, ((ValidationException)add).getResult());
        }
        if (add instanceof ValidationResultException) {
            return EnvValidationFunctions.append(arr, ((ValidationResultException)add).getResult().reportEntries);
        }
        Mirror.propagateAnyway(add);
        return null;
    }

    public static void reportOrCarryOn(List<TranslationFriendlyValidationEntry> ents) {
        if (null != ents && !ents.isEmpty()) {
            throw new MultiValidationException(ents);
        }
    }

    public static SimplePublish1<Map<String, Object>> multiAssertVariables(final String err_symbol, final GetBy1<Boolean, Object> checker, final String ... vars) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                List<TranslationFriendlyValidationEntry> ents = null;
                for (String var : vars) {
                    Object val = a.get(var);
                    if (Boolean.TRUE == checker.getBy(val)) continue;
                    ents = EnvValidationFunctions.append(ents, new TranslationFriendlyValidationEntry(var, err_symbol, new OneShotMap<String, String>("value", String.valueOf(val))));
                }
                EnvValidationFunctions.reportOrCarryOn(ents);
            }
        };
    }

    public static <C extends Comparable<C>> SimplePublish1<Map<String, Object>> multiAssertVariablesBetween(final String err_symbol, final C _min, final C _max, final String ... vars) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                List<TranslationFriendlyValidationEntry> ents = null;
                for (String var : vars) {
                    Comparable val = (Comparable)a.get(var);
                    CastTo ct = CastTo.getCasterRestrictlyForTargetClass(val.getClass());
                    Comparable min = (Comparable)ct.cast(_min);
                    Comparable max = (Comparable)ct.cast(_max);
                    if (null == min || null == max) {
                        if (null == min) {
                            ents = EnvValidationFunctions.append(ents, EnvValidationFunctions.variableTypeNotSuitable(var, val.getClass(), String.valueOf(_min)));
                        }
                        if (null != max) continue;
                        ents = EnvValidationFunctions.append(ents, EnvValidationFunctions.variableTypeNotSuitable(var, val.getClass(), String.valueOf(_max)));
                        continue;
                    }
                    if (min.compareTo(val) <= 0 && val.compareTo(max) <= 0) continue;
                    SmallMap<String, String> add = new SmallMap<String, String>();
                    add.put("value", String.valueOf(val));
                    add.put("min", String.valueOf(min));
                    add.put("max", String.valueOf(max));
                    ents = EnvValidationFunctions.append(ents, new TranslationFriendlyValidationEntry(var, err_symbol, add));
                }
                EnvValidationFunctions.reportOrCarryOn(ents);
            }
        };
    }

    protected static TranslationFriendlyValidationEntry variableTypeNotSuitable(String variable, Class type, String value) {
        SmallMap<String, String> add = new SmallMap<String, String>();
        add.put("value", value);
        add.put("asType", type.getName());
        return new TranslationFriendlyValidationEntry(variable, "Incompatible type", add);
    }

    public static SimplePublish1<Map<String, Object>> multiValidate(final SimplePublish1<Map<String, Object>> ... validators) {
        return new SimplePublish1<Map<String, Object>>(){

            @Override
            public void publish(Map<String, Object> a) {
                List<TranslationFriendlyValidationEntry> ents = null;
                for (SimplePublish1 validator : validators) {
                    try {
                        validator.publish(a);
                    }
                    catch (Throwable t) {
                        ents = EnvValidationFunctions.appendOrThrow(ents, t);
                    }
                }
                EnvValidationFunctions.reportOrCarryOn(ents);
            }
        };
    }
}

