/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.version;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.version.VariVersion;
import eu.javaexperience.version.Version;

public class StdVersion
implements Version {
    protected final int major;
    protected final int minor;
    protected final int patch;
    protected final int tweak;
    protected VariVersion variVersion;

    public StdVersion(int major, int minor, int patch, int tweak) {
        this.major = major;
        AssertArgument.assertGreaterOrEqualsThan(this.major, 0, "major");
        this.minor = minor;
        AssertArgument.assertGreaterOrEqualsThan(this.minor, 0, "minor");
        this.patch = patch;
        AssertArgument.assertGreaterOrEqualsThan(this.patch, 0, "patch");
        this.tweak = tweak;
        AssertArgument.assertGreaterOrEqualsThan(this.tweak, 0, "tweak");
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }

    @Override
    public int getTweak() {
        return this.tweak;
    }

    public StdVersion withOther(int major, int minor, int patch, int tweak) {
        return new StdVersion(major < 0 ? this.major : major, minor < 0 ? this.minor : minor, patch < 0 ? this.patch : patch, tweak < 0 ? this.tweak : tweak);
    }

    public static StdVersion parse(String str) {
        String[] vers = str.split("\\.");
        int[] a = new int[4];
        int ep = 0;
        for (int i = 0; ep < 4 && i < vers.length; ++i) {
            String s = StringTools.passOnlyNumbers(vers[i]);
            int val = ParsePrimitive.tryParseInt(s, -1);
            if (val < 0) continue;
            a[ep++] = val;
        }
        return new StdVersion(a[0], a[1], a[2], a[3]);
    }

    public String toString() {
        return "v" + this.major + "." + this.minor + "." + this.patch + "." + this.tweak;
    }

    public boolean isThisNewerThan(StdVersion thanThis) {
        int mag = this.compareTo(thanThis);
        return mag > 0;
    }

    public int hashCode() {
        int ret = 31;
        ret = 37 * ret + this.major;
        ret = 37 * ret + this.minor;
        ret = 37 * ret + this.tweak;
        ret = 37 * ret + this.patch;
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StdVersion)) {
            return false;
        }
        StdVersion v = (StdVersion)o;
        return this.major == v.major && this.minor == v.minor && this.patch == v.patch && this.tweak == v.tweak;
    }

    @Override
    public int compare(Version _this, Version thanThis) {
        return VariVersion.COMPARATOR.compare(this, thanThis);
    }

    @Override
    public int compareTo(Version thanThis) {
        return this.compare(this, thanThis);
    }

    public static void main(String[] args) {
        StdVersion old = StdVersion.parse("0.1.0.0");
        StdVersion newes = StdVersion.parse("1.0.0.0");
        AssertArgument.assertEquals(false, old.isThisNewerThan(newes), "a");
        AssertArgument.assertEquals(true, newes.isThisNewerThan(old), "b");
        AssertArgument.assertEquals(false, old.isThisNewerThan(old), "c");
        AssertArgument.assertEquals(false, newes.isThisNewerThan(newes), "d");
        AssertArgument.assertEquals(true, newes.isThisNewerThan(null), "e");
        AssertArgument.assertEquals(-1, VariVersion.COMPARATOR.compare(null, newes), "f");
        System.out.println("all passed");
    }

    @Override
    public VariVersion asVariVersion() {
        if (null == this.variVersion) {
            this.variVersion = new VariVersion(new int[]{this.major, this.minor, this.patch, this.tweak});
        }
        return this.variVersion;
    }

    @Override
    public boolean isThisNewerThan(Version thanThis) {
        int mag = this.compareTo(thanThis);
        return mag > 0;
    }

    @Override
    public int versionLevel(int lvl) {
        switch (lvl) {
            case 0: {
                return this.major;
            }
            case 1: {
                return this.minor;
            }
            case 2: {
                return this.patch;
            }
            case 3: {
                return this.tweak;
            }
        }
        return 0;
    }

    protected void assertNonNegativeSubversion(int num) {
        if (num < 0) {
            throw new RuntimeException("Invalid negative version: " + this);
        }
    }

    @Override
    public StdVersion assertValidVersion() {
        this.assertNonNegativeSubversion(this.major);
        this.assertNonNegativeSubversion(this.minor);
        this.assertNonNegativeSubversion(this.patch);
        this.assertNonNegativeSubversion(this.tweak);
        return this;
    }

    @Override
    public Version withDifferentOf(int level, int diff) {
        int major = this.major;
        int minor = this.minor;
        int patch = this.patch;
        int tweak = this.tweak;
        switch (level) {
            case 0: {
                major += diff;
                break;
            }
            case 1: {
                minor += diff;
                break;
            }
            case 2: {
                patch += diff;
                break;
            }
            case 3: {
                tweak += diff;
                break;
            }
        }
        return new StdVersion(major, minor, patch, tweak).assertValidVersion();
    }
}

