/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.arrays;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.exceptions.UnimplementedMethodException;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.BidirectionalCaster;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ListMapAdapter<K, V>
implements List<V> {
    protected Map<K, V> map;
    protected MapKeyMapper<K> caster;
    public static final MapKeyMapper<String> INDEXED_KEYS = new MapKeyMapper<String>(){

        @Override
        public String cast(Integer from) {
            return from.toString();
        }

        @Override
        public Integer castReverse(String from) {
            return ParsePrimitive.tryParseInt(from);
        }

        @Override
        public String getNextKeyValue(Map<String, ?> map) {
            int i = -1;
            for (String s : map.keySet()) {
                int val;
                Integer k = ParsePrimitive.tryParseInt(s);
                if (null == k || (val = k.intValue()) <= i) continue;
                i = val;
            }
            return String.valueOf(i + 1);
        }
    };

    public ListMapAdapter(Map<K, V> map, MapKeyMapper<K> caster) {
        this.map = map;
        AssertArgument.assertNotNull(this.map, "map");
        this.caster = caster;
        AssertArgument.assertNotNull(this.caster, "caster");
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(V e) {
        K k = this.caster.getNextKeyValue(this.map);
        this.map.put(k, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return null != this.map.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.map.containsValue(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        for (V v : c) {
            this.add(v);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        throw new UnimplementedMethodException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnimplementedMethodException();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(int index) {
        Object k = this.caster.cast(index);
        if (null == k) {
            return null;
        }
        return this.map.get(k);
    }

    @Override
    public V set(int index, V element) {
        Object k = this.caster.cast(index);
        if (null == k) {
            return null;
        }
        return this.map.put(k, element);
    }

    @Override
    public void add(int index, V element) {
        Object k = this.caster.cast(index);
        this.map.put(k, element);
    }

    @Override
    public V remove(int index) {
        Object k = this.caster.cast(index);
        if (null == k) {
            return null;
        }
        return this.map.remove(k);
    }

    @Override
    public int indexOf(Object o) {
        throw new UnimplementedMethodException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnimplementedMethodException();
    }

    @Override
    public ListIterator<V> listIterator() {
        throw new UnimplementedMethodException();
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        throw new UnimplementedMethodException();
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        throw new UnimplementedMethodException();
    }

    public static interface MapKeyMapper<T>
    extends BidirectionalCaster<Integer, T> {
        public T getNextKeyValue(Map<T, ?> var1);
    }
}

