/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.enumerations;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.CollectionReadOnlyFunctions;
import eu.javaexperience.collection.ReadOnlyAndRwCollection;
import eu.javaexperience.collection.enumerations.EnumLike;
import eu.javaexperience.collection.enumerations.EnumManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleEnumManager<T extends EnumLike<T>>
implements EnumManager<T> {
    protected ReadOnlyAndRwCollection<List<T>> values = new ReadOnlyAndRwCollection<List>(new ArrayList(), CollectionReadOnlyFunctions.MAKE_LIST_READ_ONLY);

    @Override
    public void registerElement(T elem) {
        AssertArgument.assertTrue(!elem.isRegistered(), "Enum element is already registered.");
        int ord = this.values.getWriteable().size();
        elem.setOrdinal(ord);
        elem.setEnumManager(this);
        this.values.getWriteable().add(ord, elem);
    }

    @Override
    public T getByOrdinal(int ord) {
        return (T)((EnumLike)this.values.getWriteable().get(ord));
    }

    @Override
    public T getByName(String name) {
        for (EnumLike val : this.values.getWriteable()) {
            if (!name.equals(val.getName())) continue;
            return (T)val;
        }
        return null;
    }

    @Override
    public Object[] getValues() {
        return this.values.getWriteable().toArray();
    }

    @Override
    public T[] getValues(T[] arr) {
        return (EnumLike[])this.values.getWriteable().toArray(arr);
    }

    @Override
    public List<T> getValueList() {
        return this.values.getReadOnly();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.getReadOnly().iterator();
    }
}

