/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.map;

import eu.javaexperience.collection.map.AbstractMap;
import eu.javaexperience.interfaces.simple.WrapUnwrap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MappedMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    protected Map<K, V> map;
    protected WrapUnwrap<K, K> mapper;

    public MappedMap(Map<K, V> map, WrapUnwrap<K, K> mapper) {
        this.map = map;
        this.mapper = mapper;
    }

    @Override
    public boolean containsKey(Object key) {
        K k = this.mapper.wrap(key);
        if (null != k) {
            return this.map.containsKey(k);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        K k = this.mapper.wrap(key);
        if (null != k) {
            return this.map.get(k);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        K k = this.mapper.wrap(key);
        if (null != k) {
            return this.map.put(k, value);
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        K k = this.mapper.wrap(key);
        if (null != k) {
            return this.map.remove(k);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> kv : m.entrySet()) {
            K k = this.mapper.wrap(kv.getKey());
            if (null == k) continue;
            this.map.put(k, kv.getValue());
        }
    }

    @Override
    public void clear() {
        for (K k : this.keySet()) {
            this.map.remove(this.mapper.wrap(k));
        }
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>();
        for (K k : this.map.keySet()) {
            if (null == (k = this.mapper.unwrap(k))) continue;
            keys.add(k);
        }
        return keys;
    }
}

