/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.queue;

import eu.javaexperience.collection.PublisherCollection;
import java.util.Map;
import java.util.Queue;

public class QueueAdapter<T>
extends PublisherCollection<T>
implements Queue<T> {
    protected Map<String, T> backend;
    protected int lastVal = 0;
    protected int firstVal = -1;

    public QueueAdapter(Map<String, T> backend) {
        this.backend = backend;
        for (Map.Entry<String, T> kv : backend.entrySet()) {
            Integer val;
            if (null == kv.getValue() || null == (val = Integer.valueOf(Integer.parseInt(kv.getKey())))) continue;
            this.lastVal = Math.max(this.lastVal, val);
            if (this.firstVal == -1) {
                this.firstVal = val;
                continue;
            }
            this.firstVal = Math.min(this.firstVal, val);
        }
    }

    @Override
    public boolean offer(T e) {
        return this.add(e);
    }

    @Override
    public T remove() {
        T ret = this.poll();
        this.assertNotEmpty(ret);
        return ret;
    }

    @Override
    public T element() {
        T ret = this.peek();
        this.assertNotEmpty(ret);
        return ret;
    }

    protected void assertNotEmpty(T elem) {
        if (null == elem) {
            throw new IllegalStateException("Queue is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T peek() {
        Map<String, T> map = this.backend;
        synchronized (map) {
            String key = String.valueOf(this.firstVal);
            return this.backend.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll() {
        Map<String, T> map = this.backend;
        synchronized (map) {
            String key = String.valueOf(this.firstVal++);
            T ret = this.backend.get(key);
            this.backend.remove(key);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T obj) {
        Map<String, T> map = this.backend;
        synchronized (map) {
            this.backend.put(String.valueOf(this.lastVal++), obj);
        }
        return true;
    }
}

