/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.collection.tree;

import eu.javaexperience.collection.tree.TreeNode;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import java.util.Collection;

public class TreeNodeTools {
    public static <N extends TreeNode<N>, E> N getByPath(N root, E[] elems, GetBy1<E, N> getNodeId) {
        return TreeNodeTools.getByPath(root, elems, 0, getNodeId);
    }

    public static <N extends TreeNode<N>, E> N getByPath(N root, E[] elems, int lvl, GetBy1<E, N> getNodeId) {
        if (elems.length == lvl) {
            return root;
        }
        E tar = elems[lvl];
        for (TreeNode c : root.childs) {
            if (!tar.equals(getNodeId.getBy(c))) continue;
            return (N)TreeNodeTools.getByPath(c, elems, lvl + 1, getNodeId);
        }
        return null;
    }

    public static <N extends TreeNode<N>, E> N getOrCreatePath(N root, E[] elems, GetBy1<E, N> getNodeId, GetBy1<N, E> createNode) {
        return TreeNodeTools.getOrCreatePath(root, elems, 0, getNodeId, createNode);
    }

    public static <N extends TreeNode<N>, E> N getOrCreatePath(N root, E[] elems, int lvl, GetBy1<E, N> getNodeId, GetBy1<N, E> createNode) {
        if (elems.length == lvl) {
            return (N)root;
        }
        E tar = elems[lvl];
        for (TreeNode c : root.childs) {
            if (!tar.equals(getNodeId.getBy(c))) continue;
            return (N)TreeNodeTools.getOrCreatePath(c, elems, lvl + 1, getNodeId, createNode);
        }
        TreeNode ch = (TreeNode)createNode.getBy(tar);
        root.addChild((TreeNode)ch);
        return (N)TreeNodeTools.getOrCreatePath(ch, elems, lvl + 1, getNodeId, createNode);
    }

    public static <N extends TreeNode<N>, E> void getPathToRoot(Collection<E> path, N node, GetBy1<E, N> getNodeId) {
        if (null != node) {
            do {
                path.add(getNodeId.getBy(node));
            } while (null != (node = node.getParent()));
        }
    }
}

