/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.accessModel;

import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.collection.set.NullSet;
import eu.javaexperience.database.accessModel.DataAccessModel;
import eu.javaexperience.database.accessModel.OptionEntry;
import eu.javaexperience.database.accessModel.OptionGroup;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AccessRequest<M, ENV> {
    protected DataAccessModel<M, ENV> model;
    protected MultiMap<OptionGroup, OptionEntry> selectedOptions = new MultiMap(new SmallMap());
    protected MultiMap<OptionGroup, String> unboundValue = new MultiMap(new SmallMap());

    public void examineRequest(GetBy1<Object, String> src) {
        for (OptionGroup g : this.model.queryOptions.values()) {
            Object in = src.getBy(g.systemName);
            this.typeCastOptionPut(g, in);
        }
    }

    protected void typeCastOptionPut(OptionGroup g, Object in) {
        block4: {
            block5: {
                block3: {
                    if (null == in) {
                        return;
                    }
                    if (!(in instanceof String)) break block3;
                    this.examineAndPutSelectedOption(g, (String)in);
                    break block4;
                }
                if (!in.getClass().isArray()) break block5;
                int len = Array.getLength(in);
                for (int i = 0; i < len; ++i) {
                    Object at = Array.get(in, i);
                    this.typeCastOptionPut(g, at);
                }
                break block4;
            }
            if (!(in instanceof Collection)) break block4;
            Collection coll = (Collection)in;
            for (Object o : coll) {
                this.typeCastOptionPut(g, o);
            }
        }
    }

    protected void examineAndPutSelectedOption(OptionGroup grp, String value) {
        for (OptionEntry e : grp.options) {
            if (!e.optionAddress.equals(value)) continue;
            this.selectedOptions.put(grp, e);
            return;
        }
        this.unboundValue.put(grp, value);
    }

    public OptionGroup getOptionGroupByName(String name) {
        for (OptionGroup g : this.model.queryOptions.values()) {
            if (!g.systemName.equals(name)) continue;
            return g;
        }
        return null;
    }

    public Iterable<OptionEntry> getBoundedValues(String optionName) {
        List<OptionEntry> bound;
        OptionGroup grp = this.getOptionGroupByName(optionName);
        if (null != grp && null != (bound = this.selectedOptions.getList(grp))) {
            return bound;
        }
        return NullSet.instance;
    }

    public OptionEntry getFirstBoundedValue(String grp) {
        Iterable<OptionEntry> re = this.getBoundedValues(grp);
        Iterator<OptionEntry> iterator = re.iterator();
        if (iterator.hasNext()) {
            OptionEntry e = iterator.next();
            return e;
        }
        return null;
    }

    public String getFirstBoundedValueAsString(String grp) {
        Iterable<OptionEntry> re = this.getBoundedValues(grp);
        Iterator<OptionEntry> iterator = re.iterator();
        if (iterator.hasNext()) {
            OptionEntry e = iterator.next();
            return e.optionAddress;
        }
        return null;
    }

    public Iterable<String> getUnboundedValue(String optionName) {
        List<String> bound;
        OptionGroup grp = this.getOptionGroupByName(optionName);
        if (null != grp && null != (bound = this.unboundValue.getList(grp))) {
            return bound;
        }
        return NullSet.instance;
    }

    public String getFirstUnboundValue(String grp) {
        Iterable<String> re = this.getUnboundedValue(grp);
        Iterator<String> iterator = re.iterator();
        if (iterator.hasNext()) {
            String e = iterator.next();
            return e;
        }
        return null;
    }

    public abstract void executeRequest(ENV var1, Collection<M> var2) throws SQLException, IOException;

    public void getParams(Map<String, String[]> opts, boolean bound, boolean unbound) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (OptionGroup og : this.model.queryOptions.values()) {
            List<Object> lst;
            all.clear();
            if (bound && null != (lst = this.selectedOptions.getList(og))) {
                for (Object e : lst) {
                    all.add(((OptionEntry)e).optionAddress);
                }
            }
            if (unbound && null != (lst = this.unboundValue.getList(og))) {
                for (Object e : lst) {
                    all.add(e);
                }
            }
            if (all.size() <= 0) continue;
            opts.put(og.systemName, all.toArray(Mirror.emptyStringArray));
        }
    }
}

