/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.failsafe;

import eu.javaexperience.database.failsafe.JdbcFailSafeConnection;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class FailSafeStatement
implements Statement {
    protected JdbcFailSafeConnection conn;
    private Statement _;

    public FailSafeStatement(JdbcFailSafeConnection conn) throws SQLException {
        this.conn = conn;
        this.recreate();
    }

    protected void recreate() throws SQLException {
        try {
            this._ = this.conn.conn.createStatement();
        }
        catch (SQLException e) {
            this.conn.reconnect(e);
            for (int i = 1; i < this.conn.att; ++i) {
                try {
                    this._ = this.conn.conn.createStatement();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        LoggingTools.tryLogFormat(JdbcFailSafeConnection.LOG, (LoggingDetailLevel)LogLevel.DEBUG, " %s boolean execute(%s)", (Object)this._.hashCode(), (Object)arg0);
        try {
            return this._.execute(arg0);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.conn.reconnect(e);
                this.recreate();
                try {
                    return this._.execute(arg0);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        LoggingTools.tryLogFormat(JdbcFailSafeConnection.LOG, (LoggingDetailLevel)LogLevel.DEBUG, " %s ResultSet execute(%s)", (Object)this._.hashCode(), (Object)arg0);
        try {
            return this.conn.publishClosable(this._.executeQuery(arg0));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.conn.reconnect(e);
                this.recreate();
                try {
                    return this.conn.publishClosable(this._.executeQuery(arg0));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String a, String[] b) throws SQLException {
        try {
            return this._.execute(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.execute(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String a, int b) throws SQLException {
        try {
            return this._.execute(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.execute(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean execute(String a, int[] b) throws SQLException {
        try {
            return this._.execute(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.execute(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String a, String[] b) throws SQLException {
        try {
            return this._.executeUpdate(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.executeUpdate(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String a, int[] b) throws SQLException {
        try {
            return this._.executeUpdate(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.executeUpdate(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String a, int b) throws SQLException {
        try {
            return this._.executeUpdate(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.executeUpdate(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int executeUpdate(String a) throws SQLException {
        LoggingTools.tryLogFormat(JdbcFailSafeConnection.LOG, (LoggingDetailLevel)LogLevel.DEBUG, " %s int executeUpdate(%s)", (Object)this._.hashCode(), (Object)a);
        try {
            return this._.executeUpdate(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.executeUpdate(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._.getMaxFieldSize();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getMaxFieldSize();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int a) throws SQLException {
        try {
            this._.setMaxFieldSize(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setMaxFieldSize(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._.getMaxRows();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getMaxRows();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setMaxRows(int a) throws SQLException {
        try {
            this._.setMaxRows(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setMaxRows(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean a) throws SQLException {
        try {
            this._.setEscapeProcessing(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setEscapeProcessing(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._.getQueryTimeout();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getQueryTimeout();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int a) throws SQLException {
        try {
            this._.setQueryTimeout(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setQueryTimeout(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._.cancel();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.cancel();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._.getWarnings();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getWarnings();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._.clearWarnings();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.clearWarnings();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setCursorName(String a) throws SQLException {
        try {
            this._.setCursorName(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setCursorName(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.conn.publishClosable(this._.getResultSet());
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this.conn.publishClosable(this._.getResultSet());
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._.getUpdateCount();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getUpdateCount();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int a) throws SQLException {
        try {
            return this._.getMoreResults(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getMoreResults(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this._.getMoreResults();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getMoreResults();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int a) throws SQLException {
        try {
            this._.setFetchDirection(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setFetchDirection(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._.getFetchDirection();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getFetchDirection();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setFetchSize(int a) throws SQLException {
        try {
            this._.setFetchSize(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setFetchSize(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._.getFetchSize();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getFetchSize();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._.getResultSetConcurrency();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getResultSetConcurrency();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._.getResultSetType();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getResultSetType();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void addBatch(String a) throws SQLException {
        try {
            this._.addBatch(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.addBatch(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._.clearBatch();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.clearBatch();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this._.executeBatch();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.executeBatch();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.conn.publishClosable(this._.getGeneratedKeys());
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this.conn.publishClosable(this._.getGeneratedKeys());
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._.getResultSetHoldability();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getResultSetHoldability();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._.isClosed();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.isClosed();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean a) throws SQLException {
        try {
            this._.setPoolable(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.setPoolable(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this._.isPoolable();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.isPoolable();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this._.closeOnCompletion();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.closeOnCompletion();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this._.isCloseOnCompletion();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.isCloseOnCompletion();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this._.getConnection();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.getConnection();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public boolean isWrapperFor(Class a) throws SQLException {
        try {
            return this._.isWrapperFor(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.isWrapperFor(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public Object unwrap(Class a) throws SQLException {
        try {
            return this._.unwrap(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    return this._.unwrap(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._.close();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.conn.att; ++i) {
                this.recreate();
                try {
                    this._.close();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }
}

