/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.database.failsafe;

import eu.javaexperience.database.ConnectionBuilder;
import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.failsafe.FailSafeDatabaseMetadata;
import eu.javaexperience.database.failsafe.FailSafePreparedStatement;
import eu.javaexperience.database.failsafe.FailSafeStatement;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class JdbcFailSafeConnection
implements Connection {
    public static Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("SQLDB"));
    protected final ConnectionCreator cc;
    protected Connection conn;
    protected int att;
    protected LinkedList<AutoCloseable> openedz;

    public JdbcFailSafeConnection(ConnectionBuilder cb, String host, int port, String user, String password, String db, int attempt) throws SQLException {
        this(ConnectionCreator.fromConnectionBuilder(cb, host, port, user, password, db), attempt);
    }

    public JdbcFailSafeConnection(ConnectionCreator cc, int attempt) throws SQLException {
        this.cc = cc;
        this.reconnect(null);
        this.att = attempt;
    }

    protected void reconnect(Throwable t) throws SQLException {
        if (null != t) {
            LoggingTools.tryLogFormatException(LOG, LogLevel.WARNING, t, "void JdbcFailSafeConnection.reconnect()");
        }
        this.conn = this.createNewConnection();
    }

    protected Connection createNewConnection() throws SQLException {
        return (Connection)this.cc.get();
    }

    <T extends AutoCloseable> T publishClosable(T p) {
        if (null != this.openedz) {
            this.openedz.add(p);
        }
        return p;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            return this.publishClosable(new FailSafeStatement(this));
        }
        catch (SQLException e) {
            for (int i = 1; i != this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(new FailSafeStatement(this));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return new FailSafeDatabaseMetadata(this);
        }
        catch (SQLException e) {
            for (int i = 1; i != this.att; ++i) {
                this.reconnect(e);
                try {
                    return new FailSafeDatabaseMetadata(this);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void abort(Executor a) throws SQLException {
        try {
            this.conn.abort(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.abort(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Statement createStatement(int a, int b, int c) throws SQLException {
        try {
            return this.publishClosable(this.conn.createStatement(a, b, c));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(this.conn.createStatement(a, b, c));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Statement createStatement(int a, int b) throws SQLException {
        try {
            return this.publishClosable(this.conn.createStatement(a, b));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(this.conn.createStatement(a, b));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a, String[] b) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a, int b, int c, int d) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a, b, c, d));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a, b, c, d));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a, int b) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a, int b, int c) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a, b, c));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a, b, c));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String a, int[] b) throws SQLException {
        try {
            return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(FailSafePreparedStatement.create(this, a, b));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String a, int b, int c) throws SQLException {
        try {
            return this.publishClosable(this.conn.prepareCall(a, b, c));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(this.conn.prepareCall(a, b, c));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String a, int b, int c, int d) throws SQLException {
        try {
            return this.publishClosable(this.conn.prepareCall(a, b, c, d));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(this.conn.prepareCall(a, b, c, d));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String a) throws SQLException {
        try {
            return this.publishClosable(this.conn.prepareCall(a));
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.publishClosable(this.conn.prepareCall(a));
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public String nativeSQL(String a) throws SQLException {
        try {
            return this.conn.nativeSQL(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.nativeSQL(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean a) throws SQLException {
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "%s void setAutoCommit(%s)", (Object)this.conn.hashCode(), (Object)a);
        try {
            this.conn.setAutoCommit(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setAutoCommit(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.conn.getAutoCommit();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getAutoCommit();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "%s void commit()", (Object)this.conn.hashCode());
        try {
            this.conn.commit();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.commit();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "%s void rollback()", (Object)this.conn.hashCode());
        try {
            this.conn.rollback();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.rollback();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint a) throws SQLException {
        try {
            this.conn.rollback(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.rollback(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.conn.isClosed();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.isClosed();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setCatalog(String a) throws SQLException {
        try {
            this.conn.setCatalog(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setCatalog(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.conn.getCatalog();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getCatalog();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int a) throws SQLException {
        LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.DEBUG, "%s void setTransactionIsolation(%s)", (Object)this.conn.hashCode(), (Object)a);
        try {
            this.conn.setTransactionIsolation(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setTransactionIsolation(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.conn.getTransactionIsolation();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getTransactionIsolation();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.conn.getWarnings();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getWarnings();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.conn.clearWarnings();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.clearWarnings();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.conn.getTypeMap();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getTypeMap();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public void setTypeMap(Map a) throws SQLException {
        try {
            this.conn.setTypeMap(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setTypeMap(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setHoldability(int a) throws SQLException {
        try {
            this.conn.setHoldability(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setHoldability(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.conn.getHoldability();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getHoldability();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.conn.setSavepoint();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.setSavepoint();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String a) throws SQLException {
        try {
            return this.conn.setSavepoint(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.setSavepoint(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint a) throws SQLException {
        try {
            this.conn.releaseSavepoint(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.releaseSavepoint(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            return this.conn.createClob();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createClob();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            return this.conn.createBlob();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createBlob();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            return this.conn.createNClob();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createNClob();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.conn.createSQLXML();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createSQLXML();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isValid(int a) throws SQLException {
        try {
            return this.conn.isValid(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.isValid(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties a) throws SQLClientInfoException {
        this.conn.setClientInfo(a);
    }

    @Override
    public void setClientInfo(String a, String b) throws SQLClientInfoException {
        this.conn.setClientInfo(a, b);
    }

    @Override
    public String getClientInfo(String a) throws SQLException {
        try {
            return this.conn.getClientInfo(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getClientInfo(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.conn.getClientInfo();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getClientInfo();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String a, Object[] b) throws SQLException {
        try {
            return this.conn.createArrayOf(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createArrayOf(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public Struct createStruct(String a, Object[] b) throws SQLException {
        try {
            return this.conn.createStruct(a, b);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.createStruct(a, b);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setSchema(String a) throws SQLException {
        try {
            this.conn.setSchema(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setSchema(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.conn.getSchema();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getSchema();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setNetworkTimeout(Executor a, int b) throws SQLException {
        try {
            this.conn.setNetworkTimeout(a, b);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setNetworkTimeout(a, b);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.conn.getNetworkTimeout();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.getNetworkTimeout();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean a) throws SQLException {
        try {
            this.conn.setReadOnly(a);
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.setReadOnly(a);
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.conn.close();
            return;
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    this.conn.close();
                    return;
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.conn.isReadOnly();
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.isReadOnly();
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public boolean isWrapperFor(Class a) throws SQLException {
        try {
            return this.conn.isWrapperFor(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.isWrapperFor(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public Object unwrap(Class a) throws SQLException {
        try {
            return this.conn.unwrap(a);
        }
        catch (SQLException e) {
            for (int i = 1; i < this.att; ++i) {
                this.reconnect(e);
                try {
                    return this.conn.unwrap(a);
                }
                catch (SQLException e2) {
                    continue;
                }
            }
            throw e;
        }
    }

    public void closeOpenedResources() throws Exception {
        Iterator it = this.openedz.iterator();
        while (it.hasNext()) {
            ((AutoCloseable)it.next()).close();
            it.remove();
        }
    }

    public void closeOpenedResourcesSilent() {
        Iterator it = this.openedz.iterator();
        while (it.hasNext()) {
            try {
                ((AutoCloseable)it.next()).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            it.remove();
        }
    }
}

